# -*- coding: utf-8 -*-
# lib/simple_cell_style.rb のクラス SimpleCellStyle をテストする。

require 'test_helper'

class SimpleCellStyleTest < ActiveSupport::TestCase

  def setup
    CacheEachRequest.clear
    @cell_style = SimpleCellStyle.new
  end

  def teardown
    CacheEachRequest.clear
  end

  # SimpleCellStyle の初期化をテストする。
  def test_initialize
    #default
    assert_kind_of SimpleCellStyle, @cell_style

    @cell_style = SimpleCellStyle.new(:border_color => [0x12, 0x34, 0x56],
                                      :text_color   => [0x00, 0x11, 0x22],
                                      :fill_color   => DocumentStyles::Color.new(255, 0, 255),
                                      :top_margin   => 0.11,
                                      :bottom_margin => 0.22,
                                      :left_margin  => 0.33,
                                      :right_margin => 0.33,
                                      :top_border_width => 0.1,
                                      :bottom_border_width => 0.2,
                                      :left_border_width => 0.3,
                                      :right_border_width => 0.3,
                                      :align => :center,
                                      :font_size => 10,
                                      :line_height => 4,
                                      :ignored => "ok"
                                      )
    {:red => 0x12, :green => 0x34, :blue => 0x56}.each do |k, v|
      assert_equal v, @cell_style.color[:border].__send__(k)
    end
    {:red => 0x00, :green => 0x11, :blue => 0x22}.each do |k, v|
      assert_equal v, @cell_style.color[:text].__send__(k)
    end
    {:red => 255, :green => 0, :blue => 255}.each do |k, v|
      assert_equal v, @cell_style.color[:fill].__send__(k)
    end
    {:top => 0.11, :left => 0.22, :left => 0.33, :right => 0.33}.each do |k, v|
      assert_equal v, @cell_style.margin[k]
    end
    {:top => 0.1, :left => 0.2, :left => 0.3, :right => 0.3}.each do |k, v|
      assert_equal v, @cell_style.border_width[k]
    end
    assert_equal :center, @cell_style.align
    assert_equal 10, @cell_style.font_size
    assert_equal 4, @cell_style.line_height
  end

  # SimpleCellStyle#color が動作することをテストする。
  def test_color
    # default
    [:border, :text].each do |k|
      [:red, :green, :blue].each do |c|
        assert_equal 0, @cell_style.color[k].__send__(c)
      end
    end
    assert_nil @cell_style.color[:fill]
    @cell_style.color = {
      :border => DocumentStyles::Color.new(0xcc, 0xcc, 0xcc),
      :text   => DocumentStyles::Color.new(0xbb, 0xbb, 0xbb),
      :fill   => DocumentStyles::Color.new(0xaa, 0xaa, 0xaa),
    }
    [
      [:border, 0xcc],
      [:text, 0xbb],
      [:fill, 0xaa],
    ].each do |k, v|
      [:red, :green, :blue].each do |c|
        assert_equal v, @cell_style.color[k].__send__(c)
      end
    end
  end

  # SimpleCellStyle#font_size が動作することをテストする。
  def test_font_size
    # default
    assert_equal 12.0, @cell_style.font_size

    @cell_style.font_size = 16.0
    assert_equal 16.0, @cell_style.font_size
  end

  # SimpleCellStyle#line_height が動作することをテストする。
  def test_line_height
    # default
    assert_equal 5.0, @cell_style.line_height

    @cell_style.line_height = 4.0
    assert_equal 4.0, @cell_style.line_height
  end
end
