# -*- coding: utf-8 -*-
# app/models/shared_list.rb のクラス SharedList をテストする。

require 'test_helper'

class SharedListTest < ActiveSupport::TestCase
  fixtures(:domains, :people, :users,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :displays, :items, :shared_lists)

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # SharedList#name が名前を返す。
  def test_name
    shared = shared_lists(:one)
    assert shared.name
  end

  # SharedList#creator は作成者を返す。
  def test_creator
    person = shared_lists(:one).creator
    assert_kind_of Person, person
    assert_equal 1, person.id
  end

  # SharedList#export が許可された個人に対して一覧を返す。
  def test_export__success
    User.current = users(:long_user)
    shared = shared_lists(:one)
    list = shared.export(people(:two))
    assert_kind_of DisplayToListPrivate, list
    assert_equal 2, list.person_id
  end

  # SharedList#export が許可されていない個人に対してエラーを投げる。
  def test_export__failure
    shared = shared_lists(:one)
    assert_raise(ArgumentError) do
      shared.export(people(:nisiyama))
    end
  end

  # SharedList#include? が共有先に含まれる利用者かどうかを判定する。
  def test_include?
    shared = shared_lists(:one)
    assert shared.include?(people(:two))
    assert !shared.include?(people(:nisiyama))
  end
end
