# -*- coding: utf-8 -*-
# app/models/portlet.rb のクラス Portlet をテストする。

require 'test_helper'

class PortletTest < ActiveSupport::TestCase
  fixtures :portlets, :portlet_configs, :cells, :panes

  def setup
    CacheEachRequest.clear
    User.current = User.find_by_login("tesla")
  end

  def teardown
    CacheEachRequest.clear
  end

  TITLE = [
    [1, "TopMenu 2"],
    [2, "SubMenu 3 4"],
    [3, "SubMenu 2 1"],
    [4, "TopMenu 1"],
    [5, "SubMenu 1 1"],
    [6, "SubMenu 1 2"],
  ]

  # Portalet#title がポートレットのタイトルを返すことをテストする。
  def test_title
    TITLE.each do |id, expected|
      assert_equal expected, Portlet.find(id).title
    end
  end

  # Portalet#cell がセルを返すことをテストする。
  def test_cell
    (1..6).each do |id|
      assert_kind_of Cell, Portlet.find(id).cell
    end
  end

  # Portalet#destroy 直後の動作をテストする。
  def test_after_destroy
    (1..6).each do |id|
      portlet = Portlet.find(id)
      cell_id = portlet.cell.id
      assert cell_id
      portlet.destroy
      assert_raise(ActiveRecord::RecordNotFound) do
        Cell.find(cell_id)
      end
    end
  end
end
