# -*- coding: utf-8 -*-
# app/models/portal.rb のクラス Portal をテストする。

require 'test_helper'

class PortalTest < ActiveSupport::TestCase
  fixtures :domains, :users, :portals, :portlets, :panes, :cells, :screens

  def setup
    CacheEachRequest.clear
    User.current = User.find_by_login("tesla")
    @portal = Portal.find(1)
  end

  def teardown
    CacheEachRequest.clear
  end

  # Portal#size がサイズを表す文字を返すことをテストする。
  def test_size
    assert_equal "S", @portal.size(:A)
    assert_equal "L", @portal.size(:B)
    assert_equal "S", @portal.size(:C)
  end

  # Portal#pane がペインを返すことをテストする。
  def test_pane
    assert_equal Pane.find(5), @portal.pane(:A)
    assert_equal Pane.find(6), @portal.pane(:B)
    assert_equal Pane.find(7), @portal.pane(:C)
  end

  # Portal#count がポートレットの個数を返すことをテストする。
  def test_count
    assert_equal 2, @portal.count(:A)
    assert_equal 2, @portal.count(:B)
    assert_equal 2, @portal.count(:C)
  end

  # Portal#update_pattern がポータルのパターンを更新することをテストする。
  def test_update_pattern
    @portal.update_pattern(:ABB)
    assert_equal "ABB", @portal.pattern
  end
end
