# -*- coding: utf-8 -*-
# app/models/po_message_plural.rb のクラス PoMessagePlural をテストする。

require 'test_helper'

class PoMessagePluralTest < ActiveSupport::TestCase
  fixtures :po_messages, :po_arguments, :po_translations

  def test_to_po_string
    assert_equal <<PO_STRING, po_messages(:two).to_po_string
msgid "1|There is an item."
msgid_plural "There are %{num} items."
PO_STRING
    assert_equal <<PO_STRING, po_messages(:rfw_100001).to_po_string
msgid "1|rfw|Attachment|%{count} file attached"
msgid_plural "%{count} files attached"
PO_STRING
  end

  def test_to_po_string_global
    assert_equal <<PO_STRING, po_messages(:two).to_po_string_global
msgid "There is an item."
msgid_plural "There are %{num} items."
PO_STRING
    assert_equal <<PO_STRING, po_messages(:rfw_100001).to_po_string_global
msgid "rfw|Attachment|%{count} file attached"
msgid_plural "%{count} files attached"
PO_STRING
  end
end
