# -*- coding: utf-8 -*-
require 'test_helper'

class PjInputOptionTest < ActiveSupport::TestCase
  fixtures(:domains, :po_messages, :po_translations, :projects,
           :pj_input_options, :pj_input_option_categories, :pj_input_option_values)

  # PjInputOption.generate_input_options が与えられたカテゴリと project_id から選択肢を生成する。
  def test_generate_input_options
    assert PjInputOption.generate_input_options("foo", :project_id => 1)
    assert_equal 3, PjInputOption.find(:all, :conditions => {:category => "foo", :project_id => 1}).size
  end

  # PjInputOption.generate_input_options が与えられたカテゴリと追加の project_id から選択肢を生成する。
  def test_generate_input_options__rest
    assert PjInputOption.generate_input_options("foo", {:project_id => 1}, {:project_id => 100})
    assert_equal 3, PjInputOption.find(:all, :conditions => {:category => "foo", :project_id => 100}).size
  end

  # PjInputOption.options_for_select で選択肢の集まりを返す。
  def test_options_for_select
    assert PjInputOption.generate_input_options("foo", :project_id => 1)
    options = PjInputOption.options_for_select("foo", 1)
    assert_equal %w|1 2 3|, options.map(&:last)
    assert PjInputOption.generate_input_options("bar", :project_id => 2)
    options = PjInputOption.options_for_select("bar", 2)
    assert_equal %w|ni ho|, options.map(&:last)
  end

  # PjInputOption.option_name で選択肢の名前を返す。
  def test_option_name
    assert PjInputOption.generate_input_options("foo", :project_id => 1)
    assert PjInputOption.option_name("foo", 1, "1")
    assert PjInputOption.generate_input_options("bar", :project_id => 1)
    assert PjInputOption.option_name("bar", 1, "i")
  end
end
