require 'test_helper'

class PathnameTest < ActiveSupport::TestCase
  def setup
    @rails_root_temp = File.join(RAILS_ROOT, 'tmp')
  end

  def test_tempfile_path
    assert_equal("#{RAILS_ROOT}/tmp/aaa",
                 Pathname.tempfile_path('aaa', @rails_root_temp).to_s)
  end

  def test_tempfile_path__dot_1
    assert_equal("#{RAILS_ROOT}/tmp/aaa",
                 Pathname.tempfile_path('./aaa', @rails_root_temp).to_s)
  end

  def test_tempfile_path__dot_2
    assert_raise(ArgumentError) do
      Pathname.tempfile_path('../aaa', @rails_root_temp)
    end
  end

  def test_tempfile_path__dot_3
    assert_raise(ArgumentError) do
      Pathname.tempfile_path('../etc/passwd', '/tmp')
    end
  end

  def test_tempfile_path__default_1
    ENV['TMPDIR'] = File.join(RAILS_ROOT, 'tmp')
    assert_equal("#{RAILS_ROOT}/tmp/aaa",
                 Pathname.tempfile_path('aaa').to_s)
  end

  def test_tempfile_path__default_2
    ENV['TMPDIR'] = nil
    assert_equal("/tmp/aaa",
                 Pathname.tempfile_path('aaa').to_s)
  end
end
