require 'test_helper'

class ItemPseudo::AccountItemSelectTest < ActiveSupport::TestCase
  fixtures :account_items

  def setup
    @item = ItemPseudo.new
    @adapter = ItemPseudo::AccountItemSelect.new(@item)
    @item.stubs(:adapter).returns(@adapter)
    @item.stubs(:column_name).returns("column1")
  end

  def test_to_data
    it = mock('it')
    it.expects(:column1).returns(1)
    @item.to_data(it) {'xxx'}
  end

  def test_set_attributes
    x = mock('x')
    x.expects(:column1=).with(100)
    @item.set_attributes(x, {:foo => 1, :bar => "abc", :column1 => 100})
  end
end
