# -*- coding: utf-8 -*-
# app/models/group.rb のクラス Group をテストする。

require 'test_helper'

class GroupTest < ActiveSupport::TestCase
  fixtures(:people, :domains,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :posts, :posted_tos)

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # Group#exists_with_people? の動作をテストする。
  def test_exists_with_people?
    assert Group.exists_with_people?(people(:nisiyama), people(:maeda))
    assert !Group.exists_with_people?(people(:one), people(:geeko))
  end
end
