# -*- coding: utf-8 -*-
# app/models/grant_on.rb のクラス GrantOn をテストする。

require 'test_helper'

class GrantOnTest < ActiveSupport::TestCase
  fixtures(:domains, :users, :people, :organizations, :grant_ons, :permissions, :products)

  def setup
    CacheEachRequest.clear
    User.current = User.find(1000001)
  end

  def teardown
    CacheEachRequest.clear
  end

  # roleable に期間の指定がある場合期間が制限される。
  def test_restrict_period
    g = grant_ons(:two)
    g.inception = "20000101"
    g.expiry    = "20200505"
    assert g.save
    assert_equal "20060101", g.inception
    assert_equal "20161231", g.expiry
  end

  # GrantOn の新規登録直後の動作をテストする。
  def test_after_create
    spec = {
      :domain_id => 1,
      :value => "invisible",
      :inception => "20000101",
      :expiry => "20010101",
      :grant_targettable_id => 1,
      :grant_targettable_type => "Product",
      :roleable_id => 1,
      :roleable_type => "Domain",
    }
    grant_on = GrantOn.create spec
    assert [2, 1000001, 1000002, 1000003, 1000004, 1000005, 1000006, 2000001], grant_on.permissions.map(&:user_id)
  end

  # GrantOn の更新直後の動作をテストする。
  def test_after_update
    [
      [1, [1000001, 1000003]],
      [2, [1000004, 1000005]],
      [1000, [1000003]],
      [1002, [2, 1000001, 1000002, 1000003, 1000004, 1000005, 1000006, 2000001]],
    ].each do |id, user_ids|
      _test_after_update(id, user_ids)
    end
  end

  private

  def _test_after_update(id, user_ids)
    grant_on = GrantOn.find(id)
    assert grant_on.is_a?(GrantOn)
    grant_on.save
    assert user_ids, grant_on.permissions.map(&:user_id)
  end
end
