# -*- coding: utf-8 -*-
require 'test_helper'

class ExampleIssueTest < ActiveSupport::TestCase
  fixtures(:domains, :users, :people, :permissions, :products,
           :example_projects, :example_works, :example_issues)

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # acts_as_permissible によるデータの権限が適用されているかをテストする。
  def test_acts_as_permissible
    assert_readable(:tesla, [
     true,
     true,
     true,
     true,
     true,
    ])
    assert_readable(:long_user, [
     true,
     true,
     true,
     false,
     false,
    ])
    assert_writable(:tesla, [
     true,
     true,
     false,
     true,
     true,
    ])
    assert_writable(:long_user, [
     true,
     true,
     false,
     false,
     false,
    ])
  end

  private

  def assert_readable(u, a)
    assert_able(:readable?, u, a)
  end

  def assert_writable(u, a)
    assert_able(:writable?, u, a)
  end

  def assert_able(m, u, a)
    a.each_with_index do |expected, i|
      x = ExampleIssue.find(i+1)
      User.current = users(u)
      actual = x.__send__(m)
      assert_equal expected, actual, "mismatch with #{x.inspect} and #{u}"
      CacheEachRequest.clear
    end
  end
end
