# -*- coding: utf-8 -*-
# lib/custom_format_translator.rb のモジュール CustomFormatTranslator をテストする。

require 'test_helper'
$KCODE = "u"
require "custom_format_translator"

class CustomFormatTranslatorTest < ActiveSupport::TestCase
  fixtures :domains

  # CustomFormatTranslator::format_date() の出力をテストする。
  def test_format_date
    @test_date = Date.today
    
    assert_format_date "%y", "yy"
    assert_format_date "%Y", "yyyy"
    assert_format_date "%y%m", "yymm"
    assert_format_date "%y-%m", "yy-mm"
    assert_format_date "%y/%m", "yy/mm"
    assert_format_date "%y%m%d", "yymmdd"
    assert_format_date "%y-%m-%d", "yy-mm-dd"
    assert_format_date "%y/%m/%d", "yy/mm/dd"
    assert_format_date "%Y%m", "yyyymm"
    assert_format_date "%Y-%m", "yyyy-mm"
    assert_format_date "%Y/%m", "yyyy/mm"
    assert_format_date "%Y%m%d", "yyyymmdd"
    assert_format_date "%Y-%m-%d", "yyyy-mm-dd"
    assert_format_date "%Y/%m/%d", "yyyy/mm/dd"
  end

  private

  def assert_format_date(expected, format)
    assert_equal @test_date.strftime(expected), CustomFormatTranslator::format_date(@test_date, format)
  end
end
