# -*- coding: utf-8 -*-
# app/models/config_attachment.rb のクラス ConfigAttachment をテストする。

require 'test_helper'

class ConfigAttachmentTest < ActiveSupport::TestCase
  fixtures :domains, :config_attachments

  def setup
    @config_attachment = ConfigAttachment.current
  end

  # ConfigAttachment#current()  が動作することをテストする。
  def test_current
    assert @config_attachment.is_a?(ConfigAttachment)
  end

  # ConfigAttachment#validate_length() が適切なエラーを投げるかどうかテストする。
  def test_validate_length
    assert @config_attachment.validate_length(0)
    assert_raise(ConfigAttachment::MaximumLengthError) do @config_attachment.validate_length(2 << 64) end
  end

  def test_validate_filename
    assert @config_attachment.validate_filename("short_name")
    assert_raise(ConfigAttachment::FilenameMaximumBytesizeError) {@config_attachment.validate_filename("あ" * 1024)}
    assert_raise(ConfigAttachment::FilenameProhibitedCharacterError) {@config_attachment.validate_filename("わ〜く")}
  end
end
