# -*- coding: utf-8 -*-
require 'test_helper'

class ConditionTest < ActiveSupport::TestCase

  # 非標準的なテーブル名を使ったモデルが method_chain に現れる場合
  def test_extract__nonstandard_table_name
    Company.stubs(:quoted_table_name).returns("nonstandard_companies")
    Company.any_instance.stubs(:domain_id).returns(1)
    Domain.stubs(:quoted_table_name).returns("nonstandard_domains")
    Domain.any_instance.stubs(:code).returns("DOMAIN_XXX")
    x = stub(:condition_pattern => "eq",
             :method_chain => "Company#domain_id.Domain#code",
             :model_name => "Foo",
             :quoted_table_name => "foos",
             :column_name => "bar",
             :condition_value => "x",
             :reference => false,
             :option_category => false,
             :input_type => "text"
             )
    x.stubs(:quote_value).with('x').returns("'x'")
    x.extend(Condition)
    expected = <<-SQL.strip
(foos.bar IN (SELECT id FROM nonstandard_companies WHERE nonstandard_companies.domain_id IN (SELECT id FROM nonstandard_domains WHERE (nonstandard_domains.code = 'x'))))
    SQL
    assert_equal expected, x.extract
  end

end
