# -*- coding: utf-8 -*-
# app/models/company.rb のクラス Company をテストする。

require 'test_helper'

class CompanyTest < ActiveSupport::TestCase
  fixtures(:people, :domains,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :posts, :posted_tos)

  # Company#domain_id() が動作することをテストする。
  def test_domain_id
    assert_equal 1, companies(:midgaldsystems).domain_id
  end

  # Company#exists_with_people?() が動作することをテストする。
  def test_exists_with_people?
    assert Company.exists_with_people?(people(:one), people(:two))
    assert !Company.exists_with_people?(people(:one), people(:maeda))
  end
end
