# -*- coding: utf-8 -*-
# app/models/company_member.rb のクラス CompanyMember をテストする。

require 'test_helper'

class CompanyMemberTest < ActiveSupport::TestCase
  fixtures :people, :companies, :company_members

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  def test_create
    membership = CompanyMember.new do |c|
      c.domain_id = 1
      c.company_id = 3
      c.person_id = 2
      c.inception = '20090101'
      c.expiry = '99991231'
    end
    assert_difference('Permission.count', 1) do
      membership.save!
    end
  end

  def test_update
    membership = company_members(:membership_callback)
    assert_difference('membership.lock_version') do
      assert_no_difference("Permission.count") do
        membership.update_attribute(:expiry, '20201231')
      end
    end
  end

  def test_destroy
    membership = company_members(:membership_callback)
    assert_difference("Permission.count", -1) do
      membership.destroy
    end
  end
end
