# -*- coding: utf-8 -*-
# app/models/attachmemt.rb のクラス Attachment をテストする。

require 'test_helper'

class AttachmentTest < ActiveSupport::TestCase
  include TemporaryFile

  fixtures :attachments, :storage_objects, :binary_objects

  # Attachment#file() が動作することをテストする。
  def test_file
    a = Attachment.find(1)
    assert_equal StorageObject.find(1), a.file
  end

  # Attachment#copy() が動作することをテストする。
  def test_copy
    with_temporary_file(2, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx") do
      assert Attachment.find(2).copy.is_a?(Attachment)
    end
    [3, 4].each do |i|
      assert Attachment.find(i).copy.is_a?(Attachment)
    end
  end
end
