require 'test_helper'

class ApplicationHelperTest < ActiveSupport::TestCase
  fixtures :products, :config_outputs

  def setup
    @helper = Object.new
    %w[TagHelper FormHelper FormTagHelper].each {|m| @helper.extend("ActionView::Helpers::#{m}".constantize)}
    @helper.extend(ApplicationHelper)
  end

  def test_check_box_with_label
    x = '<input checked="checked" id="product_8_workflow_enabled" name="product[workflow_enabled]" type="checkbox" value="1" />' <<
      '<input name="product[workflow_enabled]" type="hidden" value="0" />' <<
      '<label for="product_8_workflow_enabled">****</label>'
    @helper.instance_variable_set("@product", products(:sub_2_1))
    assert_equal x, @helper.check_box_with_label("product","workflow_enabled","****")
  end

  def test_radio_box_with_label
    x = '<input checked="checked" id="config_output_1_file_format_csv" name="config_output[file_format]" type="radio" value="csv" />' <<
      '<label for="config_output_1_file_format_csv">CSV</label> ' <<
      '<input id="config_output_1_file_format_pdf" name="config_output[file_format]" type="radio" value="pdf" />' <<
      '<label for="config_output_1_file_format_pdf">PDF</label> ' <<
      '<input id="config_output_1_file_format_xml" name="config_output[file_format]" type="radio" value="xml" />' <<
      '<label for="config_output_1_file_format_xml">XML</label>'
    @helper.instance_variable_set("@config_output", config_outputs(:one))
    assert_equal x, @helper.radio_box_with_label("config_output", "file_format")
  end

  def test_radio_button_with_label
    x = '<input id="product_8_id_30" name="product[id]" type="radio" value="30" /><label for="product_8_id_30">****</label>'
    @helper.instance_variable_set("@product", products(:sub_2_1))
    assert_equal x, @helper.radio_button_with_label("product", "id", 30, "****")
  end

  def test_radio_button_tag_with_label
    @helper.stubs(:random_id).returns(123456789)
    x = '<input id="product_id_123456789" name="product" type="radio" value="id" /><label for="product_id_123456789">100</label>'
    @helper.instance_variable_set("@product", products(:sub_2_1))
    assert_equal x, @helper.radio_button_tag_with_label("product", "id", 100)
  end

  def test_text_area
    t = @helper.text_area('foo', 'bar')
    assert_equal '<textarea cols="30" id="foo_bar" name="foo[bar]" rows="5"></textarea>', t
  end
end
