# -*- coding: utf-8 -*-
# app/controllers/search_controller.rb のクラス SearchController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'search_controller'

# Re-raise errors caught by the controller.
class SearchController; def rescue_action(e) raise e end; end

class SearchControllerTest < Test::Unit::TestCase
  fixtures(:domains, :people, :users,
           :products, :displays, :items,
           :grant_ons, :permissions,
           :search_conditions, :search_condition_items)

  def setup
    @controller = SearchController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @request.session[:user_id] = users(:tesla)
  end

  def teardown
  end

  # index に display_id なしでアクセスした場合にエラーを返す。
  def test_index__without_display_id
    assert_raise(ArgumentError) do
      get :index
    end
  end

  # index に存在しない display_id でアクセスした場合にエラーを返す。
  def test_index__no_such_display_id
    assert_raise(ActiveRecord::RecordNotFound) do
      get :index, :display_id => 9876543210
    end
  end

  # index にまだ検索条件を指定していない一覧画面の display_id をパラメータにアクセスした場合に成功する。
  def test_index__new_condition
    get :index, :display_id => 20001
    assert_response :success
    assert_template "index"
    assert_select "div"
  end

  # index に既に検索条件を指定している一覧画面の display_id をパラメータにアクセスした場合に成功する。
  def test_index__existing_condition
    get :index, :display_id => 84
    assert_response :success
    assert_template "index"
    assert_select "div"
  end

  # SearchController#add_item に id と display_id を与えるとフォームを表示する。
  def test_add_item__popup_form
    post :add_item, :id => 1, :display_id => 84
    assert_response :success
    assert_template "add_item"
    assert_select "div"
  end

  # SearchController#order_item に display_id、id、search_condition を与えると
  # search_condition_items の順番を変更する。
  def test_order_item
    post :order_item, :display_id => 84, :id => 1, :serach_condition => "[\"item_2\", \"newbie_1\"]"
    assert_response :success
    assert_equal "text/javascript", @response.content_type
  end
end
