# -*- coding: utf-8 -*-
# app/controllers/product_generator_controller.rb のクラス ProductGeneratorController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'product_generator_controller'

# Re-raise errors caught by the controller.
class ProductGeneratorController; def rescue_action(e) raise e end; end

class ProductGeneratorControllerTest < Test::Unit::TestCase
  fixtures :domains, :users, :products, :displays, :items

  def setup
    @controller = ProductGeneratorController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("admin")

    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # ProductGeneratorController#index で一覧画面へリダイレクトされることをテストする。
  def test_index
    get :index
    assert_response :redirect
    assert_redirected_to :action => :list
  end

  # ProductGeneratorController#list で既定の一覧画面が出力されることをテストする。
  def test_list
    get :list
    assert_response :success
    assert_template "list"
    assert_select "div"
  end

  # ProductGeneratorController#show で詳細画面が出力されることをテストする。
  def test_show
    get :show, :id => 1
    assert_response :success
    assert_template "show"
    assert_select "div"
  end

  # ProductGeneratorController#new で新規作成画面が出力されることをテストする。
  def test_new
    get :new
    assert_response :success
    assert_template "product_name_form"
    assert_select "div"
  end

  # 機能作成の際にプロダクト名に大文字を指定できることをテストする。
  def test_new__ticket396
    post :new, :commit => "save", :product => {:code => "TICKET396", :type => "ProductSingle", :model_name => "Matter"}
    assert_response :redirect
    assert_redirected_to :action => "list"
  end

  # ProductGeneratorController#edit で編集画面が出力されることをテストする。
  def test_edit
    get :edit
    assert_response :success
    assert_template "product_name_form"
    assert_select "div"
  end

  # ProductGeneratorController#item_new_pseudo で疑似項目の新規作成画面が出力されることをテストする。
  def test_item_new_pseudo
    get :item_new_pseudo, :id => displays(:list1_1).id
    assert_response :success
    assert_template "item_pseudo"
    assert_select "div"
  end

  # ProductGeneratorController#item_new_pseudo に適切なパラメータが与えられた場合に
  # 疑似項目の作成が完了することをテストする。
  def test_item_create
    id = displays(:list1_1).id
    post :item_new_pseudo, :id => id, :item => {
      "code" => "ccc",
      "name_en" => "nnn",
      "adapter_name" => "mmm",
    }
    assert_response :redirect
    assert_redirected_to :action => "display_edit", :id => id
  end

  # ProductGeneratorController#item_edit で項目の編集画面が出力されることをテストする。
  def test_item_edit
    get :item_edit, :id => 1
    assert_response :success
    assert_template "item_proper"
    assert_select "div"
  end

  # ProductGeneratorController#item_update に適切なパラメータが与えられた場合に
  # 項目の作成が完了することをテストする。
  def test_item_update
    i = Item.find(1)
    xhr :post, :item_edit, :id => i.id, :item => {
      "code" => "gnu",
      "name_en" => "guru",
      "name_ru" => "foobar",
    }
    assert_response :success
    assert_equal "text/javascript", @response.content_type
  end
end
