# -*- coding: utf-8 -*-
# app/controllers/picker_controller.rb のクラス PickerController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'picker_controller'

# Re-raise errors caught by the controller.
class PickerController; def rescue_action(e) raise e end; end

class PickerControllerTest < Test::Unit::TestCase
  fixtures :users, :people, :organizations, :companies
  fixtures :company_members, :organization_members

  def setup
    @controller = PickerController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
    @user = @request.session[:user_id]
  end

  # PickerController#index でリダイレクトされることをテストする。
  def test_index
    get :index
    assert_response :redirect
    assert_redirected_to :action => :test
  end

  # PickerController#index がテンプレート 'test' による出力を行うことをテストする。
  def test_test
    get :test
    assert_response :success
    assert_template "test"
    assert_select "div"
  end

  # PickerController#pick に不正なパラメータが与えられるとリダイレクトすることをテストする。
  def test_pick
    get :pick, :return_field => "group_dummy"
    assert_response :redirect
    assert_redirected_to PickerController::PICKER_ERROR_RETURN_TO
  end

  # PickerController#group がパラメータ 'company' で成功することをテストする。
  def test_group
    get :group, :return_field => "company"
    assert_response :success
    assert_template "group"
    assert_select "div"
  end

  # PickerController#group がパラメータ 'company' で成功することをテストする。
  def test_company
    get :company, :return_field => "company"
    assert_response :success
    assert_template "company"
    assert_select "a.pick", :count => Company.count
  end

  # PickerController#company に適切なパラメータが与えられた場合に
  # テンプレート 'company' による出力が行われることをテストする。
  def test_company_with_name
    get :company, :return_field => "company", :company_name => "M"
    assert_response :success
    assert_template "company"
    expected_count = Company.count(:conditions => ["name like ?", "%M%"])
    assert_select "a.pick", :count => expected_count
  end

  # PickerController#pick に company の情報がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_company
    get :pick, :company_id => 3, :return_field => "company", :return_to => "picker_test"
    assert_response :redirect
    assert_redirected_to :action => :test
    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id[value=?]", "3"
    assert_select "#company_name[value=?]", "XYZ"
    assert_select "#organization_id" do
      assert_select "[value]", false
    end
    assert_select "#organization_name" do
      assert_select "[value]", false
    end
  end

  # PickerController#organization がパラメータ 'organization' で成功することをテストする。
  def test_organization
    get :organization, :return_field => "organization"
    assert_response :success
    assert_template "organization"
    company, = @user.person.companies.sort_by{|c| [c.name, c.id]}
    expected_count = Company.count + company.organizations.count
    assert_select "a.pick", :count => expected_count
  end

  # PickerController#organization に適切なパラメータが与えられた場合に
  # テンプレート 'organization' による出力が行われることをテストする。
  def test_organization_with_company_name
    get :organization, :return_field => "organization", :company_name => "M"
    assert_response :success
    assert_template "organization"
    expected_count = Company.count(:conditions => ["name like ?", "%M%"])
    assert_select "a.pick", :count => expected_count
  end

  # PickerController#pick に organization の情報がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_organization
    get :pick, :company_id => 1, :organization_id => 1, :return_field => "organization", :return_to => "picker_test"
    assert_response :redirect
    assert_redirected_to :action => :test
    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id" do
      assert_select "[value]", false
    end
    assert_select "#company_name" do
      assert_select "[value]", false
    end
    assert_select "#organization_id[value=?]", "1"
    assert_select "#organization_name[value=?]", "野球部"
  end

  # PickerController#pick に organization および company の情報がパラメータとして与えられた場合に
  # リダイレクト後に期待する値が取得されていることをテストする。
  def test_pick_organization_company
    get :pick, :company_id => 1, :organization_id => 1, :return_field => "organization,company", :return_to => "picker_test"
    assert_response :redirect
    assert_redirected_to :action => :test
    get :test
    assert_response :success
    assert_template "test"
    assert_select "#company_id[value=?]", "1"
    assert_select "#company_name[value=?]", "ミッドガルドシステムズ"
    assert_select "#organization_id[value=?]", "1"
    assert_select "#organization_name[value=?]", "野球部"
  end

  # PickerController#person がパラメータ 'person' で成功することをテストする。
  def test_person
    get :person, :return_field => "person"
    assert_response :success
    assert_template "person"
    assert_select "div"
  end

  # PickerController#post がパラメータ 'post' で成功することをテストする。
  def test_post
    get :post, :return_field => "post"
    assert_response :success
    assert_template "post"
    assert_select "div"
  end

  # PickerController#lump がパラメータ 'lump' で成功することをテストする。
  def test_lump
    get :lump, :return_field => "lump"
    assert_response :success
    assert_template "lump"
    assert_select "div"
  end

  # PickerController#lump がパラメータ 'lump' およびモード 'group' で成功することをテストする。
  def test_lump_group
    get :lump, :return_field => "lump", :mode => "group"
    assert_response :success
    assert_template "lump"
    assert_select "div"
  end

  # PickerController#lump がパラメータ 'lump' およびモード 'personal_group' で成功することをテストする。
  def test_lump_personal_group
    get :lump, :return_field => "lump", :mode => "personal_group"
    assert_response :success
    assert_template "lump"
    assert_select "div"
  end

  # PickerController#lump がパラメータ 'lump_people' で成功することをテストする。
  def test_lump_people
    get :lump, :return_field => "lump_people"
    assert_response :success
    assert_template "lump"
    assert_select "div"
  end

  # PickerController#lump がパラメータ 'lump_people' およびモード 'group' で成功することをテストする。
  def test_lump_people_group
    get :lump, :return_field => "lump_people", :mode => "group"
    assert_response :success
    assert_template "lump"
    assert_select "div"
  end

  # PickerController#lump がパラメータ 'lump_people' およびモード 'personal_group' で成功することをテストする。
  def test_lump_people_personal_group
    get :lump, :return_field => "lump_people", :mode => "personal_group"
    assert_response :success
    assert_template "lump"
    assert_select "div"
  end

  # PickerController#mail がパラメータ 'mail' で成功することをテストする。
  def test_mail
    get :mail, :return_field => "mail"
    assert_response :success
    assert_template "mail"
    assert_select "div"
  end

  # PickerController#record がパラメータ 'record' で成功することをテストする。
  def test_record
    get :record, :return_field => "record", :return_to => "picker_test", :record_field => "id,name,code", :record_model => "Domain"
    assert_response :success
    assert_template "record"
    assert_select "div"
    get :record, :return_field => "record", :return_to => "bar", :record_field => "code,name", :record_model => "company"
    assert_response :success
    assert_template "record"
    assert_select "div"
  end
end
