# -*- coding: utf-8 -*-
# app/controllers/menu_controller.rb のクラス MenuController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'menu_controller'

# Re-raise errors caught by the controller.
class MenuController; def rescue_action(e) raise e end; end

class MenuControllerTest < Test::Unit::TestCase
  fixtures :users, :menus

  def setup
    @controller = MenuController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = users(:tesla)
  end

  # MenuController#mock が機能ごとの出力を行うことをテストする。
  def test_mock
    [
     menus(:top_1),
     menus(:sub_3_1),
    ].each do |menu|
      menu_id = menu.id
      get :mock, :id => menu_id
      assert_response :success
      assert_template "mock"
      href = @controller.url_for({:only_path => true}.update(menu.url_options))
      assert_select "a[href=?]", href
    end

    max_id = Menu.find(:first, :order => "id DESC").id
    assert_raise ActiveRecord::RecordNotFound do
      get :mock, :id => max_id + 1
    end
  end

  # MenuController#menu_history に適切なパラメータが与えられた場合に
  # 対応する出力を行うことをテストする。
  def test_menu_history
    assert_equal [], session
    get :index
    assert_response :success
    assert_template "index"
    assert_select "div"
    assert_equal [], session[:menu_history]
    [
      [4, [4]],
      [2, [2, 4]],
      [3, [3, 2, 4]],
      [4, [4, 3, 2]],
      [3, [3, 4, 2]],
    ].each do |i, a|
      get :menu_history, :id => i
      assert_response :success
      assert_template "_menu_history"
      assert_select "span"
      assert_equal a, session[:menu_history]
    end
    assert_raise ActiveRecord::RecordNotFound do
      get :menu_history, :id => 404
    end
    assert_equal [3, 4, 2], session[:menu_history]

    # ignore missing menu
    session[:menu_history] << 404
    get :menu_history, :id => 3
    assert_response :success
    assert_template "_menu_history"
    assert_select "span"
    menus = []
    @response.body.scan(/onMenu\((\d+)\)/) do
      menus << $1.to_i
    end
    assert_equal [3, 4, 2], menus
    assert_equal [3, 4, 2, 404], session[:menu_history]
  end

  # MenuController#menu_tree がメニューツリーを出力することをテストする。
  def test_menu_tree
    get :menu_tree
    assert_response :success
    assert_template "menu_tree"
    assert_select "div"
  end

  # MenuController#about が about を出力することをテストする。
  def test_about
    get :about
    assert_response :success
    assert_template "about"
    assert_select "div"
  end
end
