# -*- coding: utf-8 -*-
# エラーメール配信のテストをする

require File.dirname(__FILE__) + '/../test_helper'

class DummyForExcepNotiferController < ActionController::Base
  include ExceptionNotifiable
  def index; bad_calling; render :text => 'test' end
end

class TestUserController < UserController
  include ExceptionNotifiable
  def login; bad_calling; render :text => 'test' end
end

class ExceptionNotifierTest < Test::Unit::TestCase

  def configure
    @sender   = %|"Admin" <admin@example.com>|
    @to       = ['test1@example.com', 'test2@example.com']
    @prefix   = '[TEST_ERROR] '
    @sections = %w[request session environment backtrace]
    [
      [:sender_address,       @sender],
      [:exception_recipients, @to],
      [:email_prefix,         @prefix],
      [:sections,             @sections]
    ].each do |key, value|
      ExceptionNotifier.__send__("#{key}=", value)
    end
  end

  def setup
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    CacheEachRequest.clear
    ActionMailer::Base.deliveries = []
    configure
  end

  def teardown
    CacheEachRequest.clear
    ActionMailer::Base.deliveries = []
  end

  # test in dummy controller
  def test_should_send_correct_error_mail__in_dummy_class
    @controller = DummyForExcepNotiferController.new
    @method     = :index

    get @method
    assert_response 500
    assert !ActionMailer::Base.deliveries.empty?

    mail = ActionMailer::Base.deliveries.last
    correct_mail? mail
  end

  # test in real controller
#   def test_should_send_correct_error_mail__in_real_class
#     @controller = TestUserController.new
#     @method     = :login
# 
#     UUIDHelper.stubs(:uuid).returns('uuu-uuu-uuuu-uuuuid')
# 
#     get @method
#     assert_response 500
#     assert !ActionMailer::Base.deliveries.empty?
# 
#     mail = ActionMailer::Base.deliveries.last
#     correct_mail? mail
#     assert_match /uuu-uuu-uuuu-uuuuid/, mail.body
# 
#   end

  private
  def all_match?(body, *regexps)
    regexps.all? do |regexp|
      body.enum_for(:each_line).any? do |line|
        regexp =~ line
      end
    end
  end

  # get arbitrary attributes from mail object
  def get_attributes(mail, *attributes)
    attributes.map do |attribute|
      mail.__send__(attribute) rescue nil
    end
  end

  def correct_mail?(mail)
    from, to, subject, body = get_attributes(mail, :from, :to, :subject, :body)

    assert_equal @sender[9..-2], from[0]
    assert_equal @to, to

    act_subject = /#{Regexp.escape(%|#{@prefix}#{@controller.class}##{@method} (NameError) "undefined local variable or method `bad_calling' for|)}/
    assert_match act_subject, subject

    sections = @sections.map {|s| /#{s.capitalize}:/ }
    assert all_match?(body, /bad_calling/, *sections)
  end
end

