// Place your application-specific JavaScript functions and classes here
// This file is automatically included by javascript_include_tag :defaults

// IMPORTANT NOTE: use App instead of global namespace in this file.
var App = {
  messages: {} // set in app/views/layouts/application.html.erb
};

App.DebugConsole = {
  enabled: null,
  div: null,
  divTick: null,
  init: function() {
    var self = App.DebugConsole;
    if ($("development_only")) {
      self.enabled = true;
      self.div = $("debug_console");
      self.divTick = $("debug_console_tick");
    } else {
      self.enabled = false;
    }
  },
  log: function(data) {
    if (!this.enabled) return;
    if (typeof(console) != 'undefined') {
      console.log(data);
    } else {
      new Insertion.Top(this.div, ""+data+"<br>");
    }
  },
  update: function(content) {
    if (!this.enabled) return;
    this.div.update(content);
  },
  tick: function() {
    if (!this.enabled) return;
    this.divTick.update(new Date() + ", Ajax.activeRequestCount:"+Ajax.activeRequestCount);
  },
  scrollTo: function(element) {
    if (!this.enabled) return;
    if ($F("debug_console_enable_scroll_to")) {
      element = $(element);
      if (element) {
        element.scrollTo();
      }
    }
  }
};
Event.observe(window, "load", App.DebugConsole.init);

App.AjaxLoader = {
  spinner: null,
  bgspinner: null,
//  offsetX: 15,
//  offsetY: 15,
//  moveSpinner: function(event) {
//    var self = App.AjaxLoader;
//    var x = Event.pointerX(event) + self.offsetX;
//    var y = Event.pointerY(event) + self.offsetY;
//    self.spinner.setStyle({left: x+'px', top: y+'px'});
//  },
  init: function() {
    var self = App.AjaxLoader;
    self.spinner = $("loading");
    self.bgspinner = $("bgloading");
    if (self.spinner) {
      if (self.spinner.empty()) {
        self.spinner.innerHTML = "<span>"+App.messages.ajaxLoading+"</span>";
      }
      //Event.observe(document, "mousemove", self.moveSpinner);
      //Event.observe(document, "mousedown", self.moveSpinner);
    }
    Ajax.Responders.register({
      onCreate: self.start,
      onComplete: self.stop,
      onException: self.onException
    });
  },
  start: function() {
    var self = App.AjaxLoader;
    self.spinner.show();
    if (self.bgspinner) {
      self.bgspinner.show();
      var pos = self.spinner.cumulativeOffset();
	  var x_pos = pos[0] + 5;
      self.bgspinner.setStyle({left: x_pos+'px', top: pos[1]+'px'});
    }
  },
  stop: function() {
    var self = App.AjaxLoader;
    if (Ajax.activeRequestCount <= 0) {
      //Event.stopObserving(window, "mousemove", self.onMouseMove);
      self.spinner.hide();
      if (self.bgspinner) self.bgspinner.hide();
    }
  },
  onException: function() {
    var self = App.AjaxLoader;
    // NOTE: prototype.js count up activeRequestCount at onCreate,
    // and count down at onComplete, but not care at onException.
    // if prototype.js cares at onException, remove handling activeRequestCount.
    Ajax.activeRequestCount--;
    self.stop();
    if (Ajax.activeRequestCount == 0) {
      App.History.address.loading = false;
    } else if (Ajax.activeRequestCount < 0) {
      alert(App.messages.maybeServerDown);
      Ajax.activeRequestCount++;
    }
  }
};
Event.observe(window, "load", App.AjaxLoader.init);

(function() {
  var originalUpdateContentOfAjaxUpdater = Ajax.Updater.prototype.updateContent;
  Ajax.Updater.prototype.updateContent = function(responseText) {
    var contentType = this.getHeader('Content-type');
    // already eval in Ajax.Request
    if (contentType && contentType.strip().match(/^(text|application)\/(x-)?(java|ecma)script(;.*)?$/i))
      this.container = {};
    originalUpdateContentOfAjaxUpdater.bind(this)(responseText);
  }
}());

App.History = {};
App.History.factory = function() {
  if (Prototype.Browser.IE) {
    return new App.History.browser.IE();
  } else if (Prototype.Browser.WebKit) {
    return new App.History.browser.Safari();
  } else {
    return new App.History.browser.Gecko();
  }
};

App.History.browser = {};
App.History.browser.Common = Class.create({
  delimiter: "#",
  restSeparator: ".",
  restSeparatorRegExp: "\\.",
  viewSeparator: ",",
  initialize: function() {
    this.currentHash = undefined;
    this.currentParams = $H();
    this.loading = false;
    this.overrideSetOptions();
    this.setCurrentHash(location.hash);
    this.load(this.currentHash);
    this.periodicalExecuter = new PeriodicalExecuter(this.check.bind(this), 0.1);
  },
  overrideSetOptions: function() {
    var self = this;
    var originalAjaxUpdaterInitialize = Ajax.Updater.prototype.initialize;
    Ajax.Updater.prototype.initialize = function(container, url, options) {
      App.DebugConsole.log(["initialize:", container, url, options]);
      options = Object.clone(options);
      var fragment = self.currentHash.replace(/^[^#]*#/, "");
      if (options.parameters) {
        options.parameters['fragment'] = fragment;
      } else {
        options.parameters = {fragment:fragment};
      }
      if (window._token) {
        options.parameters['authenticity_token'] = window._token;
      }
      options.evalScripts = true;
      originalAjaxUpdaterInitialize.bind(this)(container, url, options);
      var originalOnComplete = this.options.onComplete;
      var myOnComplete = function(transport, param) {
        App.DebugConsole.log(["Content-type:", transport.getHeader('Content-type')]);
        App.DocumentLayout.closeFlash();
        self.loading = false;
        var view = this.options.app_view;
        var link = this.options.app_link;
        var keys = this.options.app_keys;
        App.DebugConsole.log(["myOnComplete:", view, link, keys]);
        if (link) {
          App.SelectedLink.select(link, view);
        }
        if (view) {
          view = $(view);
          view.show();
          if (Prototype.Browser.IE && view.hasClassName("popup")) {
            new Insertion.Bottom(view, "<!--[if lte IE 6.5]><iframe class=\"select-free\"></iframe><![endif]-->");
          }
          var view_handle = view.select(".view_handle");
          if (view_handle[0]) {
            var match = view.id.match(/^view_tabs([a-z]+)([0-9]+)([a-z]+)([0-9]+)/);
            if (match) {
              view = $("view_"+match[1]);
            }
            App.DebugConsole.log(["Draggable:", view, view_handle[0]]);
            new Draggable(view, {handle:view_handle[0]});
            view_handle[0].addClassName("draggable");
          }
          /* new Effect.Highlight(view,{duration:0.5, queue:{scope:view.id,limit:2,position:"end"}}); */
        }
        if (!keys || keys.length == 0) {
          App.DebugConsole.scrollTo(view);
          App.DocumentLayout.update();
        } else {
          self.ajaxLoader(keys);
        }
      };
      this.options.onComplete = (function(transport, param) {
        originalOnComplete.bind(this)(transport, param);
        myOnComplete.bind(this)(transport, param);
      }).bind(this);
    };
  },
  setCurrentHash: function(hash) {
    hash = hash.replace(/^[^#]*#/, "");
    var new_hash = this.delimiter + hash;
    if (this.currentHash != new_hash) {
      this.currentHash = new_hash;
      this.currentParams = $H(hash.toQueryParams(this.viewSeparator));
      return hash;
    }
    return null;
  },
  check: function() {
    App.DebugConsole.tick();
    if (location.hash && location.hash != this.currentHash) {
      this.setCurrentHash(location.hash);
      this.hashChanged();
    }
  },
  loadLink: function(link) {
    App.DebugConsole.log(["loadLink:", link]);
    var match = link.id.split(/__/)[0].match(/^link_([a-z0-9]+)(_([a-z0-9]+)(_([_a-z0-9]+))?)?$/);
    if (!match) {
      return false;
    }
    var key = match[1];
    var value = match[3];
    var rest = match[5];
    var new_parts = [];
    var old_params = App.History.address.currentParams;
    var parent_view_key = null;
    var e = encodeURIComponent;
    match = key.match(/^tabs([a-z]+)([0-9]+)([a-z]+)([0-9]+)/);
    App.DebugConsole.log(["tabs match:", match]);
    if (match) {
      var tabs_id = "tabs_" + match[1];
      var $tabs = jQuery("#" + tabs_id + " > ul").tabs({cache:true});
      if ($("view_" + key)) {
        $tabs = jQuery("#" + tabs_id + " > ul").tabs();
        $tabs.tabs("select", "#view_" + key);
        App.DebugConsole.log(["tabs select:", key]);
        return true;
      } else {
        if (App.History.address.loading) {
          App.DebugConsole.log(["nowLoading", link]);
          alert(App.messages.nowLoading);
          return true;
        }
        var tab_label = link.innerHTML;
        App.DebugConsole.log(["tabs open:", key, tab_label]);
        $tabs.show();
        $tabs.tabs("add", "#view_"+key, tab_label);
        jQuery("#view_"+key).html("<div>Loading...</div>");
        var dimensions = $("view_"+key).previous().getDimensions();
        dimensions.height = dimensions.height + "px";
        dimensions.width = dimensions.width + "px";
        jQuery("#view_"+key+" > div").css(dimensions);
        $tabs.tabs("select", "#view_" + key);
      }
    }
    old_params.each(function (pair) {
      if (pair.key == key) {
        throw $break;
      } else {
        new_parts.push(e(pair.key) + "=" + e(pair.value));
        parent_view_key = pair.key;
      }
    });
    if (value == "close" || value == "pop") {
      this.close(key, parent_view_key, link);
      key = parent_view_key;
      link = null;
    } else if (link.hasClassName("reloadable_link")) {
      if (rest) {
        rest = rest.split("_").eachSlice(2, function(values, index) {
          if (values.length == 2) {
            return values.join("_");
          }
        }).compact().join(this.restSeparator);
        new_parts.push(e(key) + "=" + e(value) + this.restSeparator + e(rest));
      } else if (value) {
        new_parts.push(e(key) + "=" + e(value));
      }
    }
    var hash = new_parts.join(this.viewSeparator);
    return this.load(hash, key, link);
  },
  close: function(key, parent_view_key, link) {
    var view = $("view_" + key);
    App.DebugConsole.log(["close:", key, parent_view_key, link, view]);
    if (view) {
      view.update("");
      view.hide();
      App.SelectedLink.unselect(key);
      App.DocumentLayout.update();
      App.DebugConsole.scrollTo("view_" + parent_view_key);
    }
    if (!parent_view_key && link.href) {
      App.DebugConsole.log(["close", location, link.href]);
      new Ajax.Updater("view_main", link.href);
    }
  },
  load: function(hash, loading_key, clicked_link, sync_only) {
    App.DebugConsole.log(["load:", hash, loading_key, clicked_link, sync_only]);
    this.setCurrentHash(hash);
    location.hash = this.currentHash;
    if (sync_only) return;
    return this.hashChanged(loading_key, clicked_link);
  },
  hashChanged: function(loading_key, clicked_link) {
    App.DebugConsole.log(["hashChanged:", loading_key, clicked_link]);
    var keys;
    if (loading_key) {
      App.SelectedLink.unselect(loading_key);
      keys = [loading_key];
    } else {
      App.SelectedLink.unselect();
      keys = this.currentParams.keys();
    }
    return this.ajaxLoader(keys, clicked_link);
  },
  getReloadableLink: function(view_name, value) {
    App.DebugConsole.log(["getReloadableLink:", view_name, value]);
    var links = $$(".reloadable_link");
    var regexp = "^link_" + view_name + "_" + value + "(__|$)";
    return links.find(function(link) {
      if (link.id && link.id.match(regexp)) {
        return true;
      } else {
        return false;
      }
    });
  },
  ajaxReloadToMain: function() {
    var self = this;
    var view = $("view_main");
    self.loading = true;
    var options = {
      app_view: view,
      asynchronous:true,
      evalScripts:true
    };
    App.DebugConsole.log(["ajaxReloadToMain", view, location.href, options]);
    new Ajax.Updater(view, location.href, options);
    return true;
  },
  ajaxLoader: function(keys, clicked_link) {
    App.DebugConsole.log(["ajaxLoader:", keys, clicked_link]);
    var self = this;
    var loading_key = keys.shift();
    if (!loading_key) {
      return true;
    }
    var value = self.currentParams.get(loading_key);
    App.DebugConsole.log(["ajaxLoader:value", value]);
    var view = $("view_" + loading_key);
    App.DebugConsole.log(["ajaxLoader:view", view]);
    if (!view) {
      if (!App.History.address) {
        return self.ajaxReloadToMain();
      }
      view = $("view_main");
    }
    var link = clicked_link || self.getReloadableLink(loading_key, value.sub(this.restSeparatorRegExp + ".*", ""));
    App.DebugConsole.log(["ajaxLoader:link", link]);
    if (view && link) {
      if (self.loading != true) {
        self.loading = true;
        var options = {
          app_view: view,
          app_link: link,
          app_keys: keys,
          asynchronous:true,
          evalScripts:true
        };
        App.DebugConsole.log(["new Ajax.Updater", view, link.href, options]);
        new Ajax.Updater(view, link.href, options);
        return true;
      } else {
        App.DebugConsole.log(["nowLoading", view, link]);
        alert(App.messages.nowLoading);
        return true;
      }
    } else if (view) {
      location.hash = location.hash.sub(","+loading_key+".*", "");
      self.setCurrentHash(location.hash);
    }
    var check_box_when_ajax_failed = $("debug_console_do_not_jump_when_ajax_failed");
    if (check_box_when_ajax_failed) {
      return $F(check_box_when_ajax_failed);
    } else {
      return false;
    }
  }
});

App.History.browser.Gecko = Class.create(App.History.browser.Common, {
  initialize: function($super) {
    this.name = "Gecko";
    $super();
  }
});

App.History.browser.IE = Class.create(App.History.browser.Common, {
  initialize: function($super) {
    this.name = "IE";
    var div = new Element("div");
    div.innerHTML='<iframe id="history_internal" style="display: none;"></iframe>';
    document.body.appendChild(div);
    var history = $("history_internal");
    var iframe = history.contentWindow.document;
    iframe.open();
    iframe.close();
    iframe.location.hash = location.hash;
    $super();
  },
  check: function($super) {
    App.DebugConsole.tick();
    var history = $("history_internal");
    var iframe = history.contentDocument || history.contentWindow.document;
    var loading_hash = iframe.location.hash;
    if(loading_hash != this.currentHash && loading_hash != "#") {
      return this.load(loading_hash);
      location.hash = loading_hash;
      this.setCurrentHash(loading_hash);
      return this.hashChanged();
    }
  },
  load: function($super, hash, loading_key, clicked_link, sync_only) {
    var val = $super(hash, loading_key, clicked_link, sync_only);
    var history = $("history_internal");
    var iframe = history.contentWindow.document;
    iframe.open();
    iframe.close();
    iframe.location.hash = this.currentHash;
    return val;
  }
});

App.History.browser.Safari = Class.create(App.History.browser.Common, {
  initialize: function($super) {
    this.name = "Safari";
    this.delimiter = "";
    this.currentHistory = history.length;
    this.historyArray = new Array();
    this.historyArray[history.length] = location.hash;
    $super();
  },
  check: function($super) {
    if (this.currentHistory != history.length) {
      this.currentHistory = history.length;
      if (typeof this.historyArray[this.currentHistory] == "undefined") {
        this.historyArray[this.currentHistory] = location.hash;
        var  hash = this.trim(location.hash);
        return this.hashChanged();
      } else {
        var hash = this.historyArray[this.currentHistory];
        this.load(hash);
        return;
      }
    }
    return;

    if (this.setCurrentHash(location.hash)) {
      this.load(this.currentHash);
    }
  },
  load: function($super, hash, loading_key, clicked_link, sync_only) {
    hash = hash.replace(/^%23/, "");
    if (location.hash != "#" + hash && hash) {
      location.hash = hash;
    }
    this.setCurrentHash(hash);
    if (sync_only) return;
    return this.hashChanged(loading_key, clicked_link);
  }
});

Event.observe(window, "load", function() {
  App.History.address = App.History.factory();
  if (App.History.address.currentHash == App.History.address.delimiter) {
    var fragment_setters = $$(".fragment_setter");
    if (fragment_setters[0]) {
      return;
    }
    var autoloads = $$(".autoload");
    if (autoloads[0]) {
      autoloads[0].onclick();
    }
  }
});

App.onAjaxLink = function(link) {
  try {
    return !App.History.address.loadLink($(link));
  } catch (e) {
    alert("onAjaxLink:" + link + ":" + (e.description || e.toString()));
    return false;
  }
};
App.closeView = function(view, redirect_to) {
  setTimeout(function() {
    try {
      App.History.address.loadLink({id: "link_"+view+"_close", href:redirect_to});
    } catch (e) {
      alert("closeView:" + e.toString());
    }
  }, 10);
};

App.DocumentLayout = {
  originalTitle: document.title,
  updateTitle: function() {
    titles = $$(".title").select(function(t) {return t.childElements().size() == 0});
    document.title = titles.pluck("innerHTML").join(" : ");
  },
  flashContents: "",
  flashDraggable: null,
  flashCloseLink: null,
  updateFlash: function() {
    var self = this;
    var flash = $("flash");
    var flash_xhr_elements = $$(".flash_xhr");
    App.DebugConsole.log(["updateFlash:", flash.innerHTML, flash_xhr_elements]);
    flash_xhr_elements.each(function(flash_xhr) {
      App.DebugConsole.log(["updateFlash:", flash_xhr.innerHTML, flash_xhr.empty()]);
      if (!flash_xhr.empty()) {
        if (!self.flashCloseLink) {
          flash.addClassName("flash_ajax");
          self.flashCloseLink = "<a href='#' class='close flash' onclick='App.DocumentLayout.closeFlash();return false'>" + App.messages.closeFlash + "</a>";
        }
        if (App.DebugConsole.enabled) {
          self.flashContents += flash_xhr.innerHTML;
        } else {
          self.flashContents = flash_xhr.innerHTML;
        }
        flash.update('<div class="vspacer1em"></div>' + self.flashContents + '<div class="vspacer1em"></div>' + self.flashCloseLink);
        flash_xhr.remove();
      }
    });
    if (flash.empty()) {
      this.closeFlash();
    } else {
      flash.show();
      if (!this.flashDraggable) {
        this.flashDraggable = new Draggable(flash);
      }
      // flash.scrollTo();
      window.scrollTo(0, 0);
      /* new Effect.Highlight(flash,{duration:1.0, queue:{scope:"flash",limit:2,position:"end"}}); */
    }
  },
  closeFlash: function() {
    var flash = $("flash");
    this.flashContents = "";
    flash.update("");
    flash.hide();
  },
  updateHiddenFragment: function() {
    var fragment_setters = $$(".fragment_setter");
    var fragment_setter = fragment_setters[0];
    var hash = location.hash.replace(/^[^#]*#/, "");
    App.DebugConsole.log(["updateHiddenFragment:", fragment_setters, hash]);
    if (fragment_setter) {
      App.DebugConsole.log(["updateHiddenFragment:", fragment_setter.value, fragment_setter.name]);
      if (hash != fragment_setter.value) {
        hash = fragment_setter.value;
        if (fragment_setter.name == "sync") {
          App.History.address.load(hash, null, null, true);
        } else {
          App.History.address.load(hash);
        }
      }
      fragment_setters.each(function(e) { e.remove(); });
    }
    $A(document.forms).each(function(form) {
      var f = form.fragment;
      if (f) {
        f.value = hash;
      } else {
        var q = new Element("input");
        q.type = "hidden";
        q.name = "fragment";
        q.value = hash;
        form.appendChild(q);
      }
    });
  },
  update: function() {
    try {
      App.DocumentLayout.updateTitle();
      App.DocumentLayout.updateFlash();
      App.DocumentLayout.updateHiddenFragment();
    } catch(e) {
      alert(e);
    }
  }
};
Event.observe(window, "load", App.DocumentLayout.update);

App.SelectedLink = {
  selected: [],
  unselect: function(key) {
    if (key) {
      var re = new RegExp("^(link|indicator)_" + key + "_");
      var found = false;
      this.selected = this.selected.reject(function(e) {
        if (found || e.id.match(re)) {
          e.removeClassName("selected");
          found = true;
        }
        return found;
      });
    } else {
      this.selected.each(function(e) {
        e.removeClassName("selected");
      });
      this.selected = [];
    }
  },
  select: function(link, view) {
    var indicator = $(link.id.sub("^link_", "indicator_").sub(/__.*/, ""));
    var target;
    var offset_x;
    var offset_y;

    App.DebugConsole.log(["App.SelectedLink.select:indicator=", indicator]);
    if (indicator) {
      target = indicator;
    } else {
      try {
        indicator = link.id.sub("^link_detail_[a-z]+", "indicator_detail_show").sub(/__.*/, "");
        if (!indicator.match(/_id_/)) {
            var param = App.History.address.currentParams.get(view.id.sub(/^view_/, ""));
          if (param) {
            indicator += "_" + param.sub(/^[^.]+\./, "");
          }
        }
        App.DebugConsole.log(["App.SelectedLink.select:indicator=", indicator]);
        indicator = $(indicator);
      } catch (e) {
        App.DebugConsole.log(["App.SelectedLink.select:ignore ok:", e]);
      }
      if (indicator) {
        target = indicator;
      } else {
        target = link;
      }
    }
    this.selected.push(target);
    target.addClassName("selected");
    App.DebugConsole.log(["App.SelectedLink.select:", target]);
  }
};

App.TreeHelper = {
  closed_class: "sub_tree_closed",
  toggle: function(icon) {
    icon = $(icon);
    var branch_id = icon.up().id;
    Effect.toggle(branch_id+"_sub", "appear", {duration:0.1});
    if (icon.hasClassName(this.closed_class)) {
      icon.innerHTML = App.messages.treeIconClose;
    } else {
      icon.innerHTML = App.messages.treeIconOpen;
    }
    icon.toggleClassName(this.closed_class);
  }
};

App.MenuHistory = {
  menuHistoryUrl: null,
  onClick: function(link) {
    var match = link.id.match(/^link_m_([0-9]+)/);
    var menu_id = match[1];
    if (menu_id && this.menuHistoryUrl) {
      var url = this.menuHistoryUrl+"/"+menu_id;
      var responder = {};
      var updater_starter = function () {
        Ajax.Responders.unregister(responder);
        App.DebugConsole.log(["App.MenuHistory updater_starter:", Ajax.activeRequestCount]);
        if (Ajax.activeRequestCount > 0) {
          // start later again
          Ajax.Responders.register(responder);
        } else {
          new Ajax.Updater("menu_history", url, {
             asynchronous: true,
             evalScripts: true,
             onComplete: function (request) {
               /* new Effect.Highlight("menu_history_item_0", {queue:{scope:"menu_history",limit:2,position:"end"}}); */
              }
            });
        }
      };
      // start later
      responder = {
       onComplete: updater_starter,
       onException: updater_starter
      };
      Ajax.Responders.register(responder);
    }
  },
  init: function() {
    var menu_history_url = $("menu_history_url");
    if (menu_history_url) {
      App.MenuHistory.menuHistoryUrl = menu_history_url.href;
    }
  }
};
App.onMenu = function(menu_id, query_string) {
  if (Ajax.activeRequestCount > 0) {
    alert(App.messages.nowLoading);
    return false;
  }
  var link = $("link_m_" + menu_id);
  if (link) {
    if (query_string) {
      link.href = link.href.sub(/\?.*$/, '') + '?' + query_string;
    }
    App.MenuHistory.onClick(link);
    return onAjaxLink(link);
  } else {
    alert(App.messages.notFoundMenu + menu_id);
  }
  return false;
};
Event.observe(window, "load", App.MenuHistory.init);

App.onSubmitTag = function(submit_tag, disable_with) {
  var form = submit_tag.form;
  var q = new Element("input");
  q.type = "hidden";
  q.name = submit_tag.name;
  q.value = submit_tag.value;
  form.appendChild(q);
  Form.getInputs(form, "submit").each(function(e) {
    e.disabled = true;
  });
  submit_tag.value = disable_with;
  if (form.onsubmit) {
    form.onsubmit();
  } else {
    form.submit();
  }
  return false;
};

Event.observe(window, "load", function() {
  var menu_table = $('menu_table');
  if (menu_table && $('menu_adjuster')) {
    $('menu_adjuster').toggle();
    $('menu_handle').update('<img src="../images/handle.gif" width="20" height="16">');
    new Control.Slider('menu_handle', 'menu_track', {
      onSlide: function(v) {
        var w = 150;
        menu_table.style.width = (150 + w*v) + 'px';
        document.body.style.width = (1004 + w*v) + 'px';
      }
    });
  }
});

App.add_new_search_condition_item = function(template) {
  var newbies = $F('new_search_condition_items').evalJSON();
  var m, n;
  if (m = newbies.last()) {
    n = m + 1;
    newbies.push(n);
  } else {
    n = 1;
    newbies = [n];
  }
  $('new_search_condition_items').value = newbies.toJSON();
  var t = new Template(template);
  x = t.evaluate({n:n});
  Element.insert('search_condition', x);
  var order = $F('order_search_condition_items').evalJSON();
  order.push('newbie_' + n);
  $('order_search_condition_items').value = order.toJSON();
};
App.remove_new_search_condition_item = function(n) {
  var newbies = $F('new_search_condition_items').evalJSON();
  $('new_search_condition_items').value = newbies.without(n).toJSON();
  var order = $F('order_search_condition_items').evalJSON();
  $('order_search_condition_items').value = order.without('newbie_' + n).toJSON();
  $('newbie_' + n).remove();
};
App.remove_old_search_condition_item = function(id) {
  var old = $F('old_search_condition_items').evalJSON();
  old.push(id);
  $('old_search_condition_items').value = old.toJSON();
  var order = $F('order_search_condition_items').evalJSON();
  $('order_search_condition_items').value = order.without('item_' + id).toJSON();
  $('item_' + id).remove();
};

App.add_new_details = function(template, seed) {
  var new_details = $F('new_details_'+seed).evalJSON();
  var m, n;
  if (m = new_details.last()) {
    n = m + 1;
    new_details.push(n);
  } else {
    n = 1;
    new_details = [n];
  }
  $('new_details_'+seed).value = new_details.toJSON();
  var t = new Template(template);
  var r = Math.random().toString().replace(/^0\./,'');
  var tr = t.evaluate({n:n,random:r});
  $('details_table_body_'+seed).insert(tr);
  App.update_tablednd(seed);
};
App.remove_new_details = function(self,n, seed) {
  var tr = $(self.parentNode.parentNode);
  tr.remove();
  var new_details = $F('new_details_'+seed).evalJSON();
  var i;
  if ( (i = new_details.indexOf(n)) >= 0) {
    new_details.splice(i,1);
    $('new_details_'+seed).value = new_details.toJSON();
    App.update_tablednd(seed);
  }
};
App.remove_old_details = function(self,id,seed) {
  var tr = $(self.parentNode.parentNode);
  tr.remove();
  var old_details = $F('old_details_'+seed).evalJSON();
  old_details.push(id);
  $('old_details_'+seed).value = old_details.toJSON();
  App.update_tablednd(seed);
};
App.update_tablednd = function(seed){
  jQuery('#details_table_'+seed).tableDnDUpdate();
  jQuery('#details_table_'+seed+' tbody tr:even').addClass("even").removeClass("odd");
  jQuery('#details_table_'+seed+' tbody tr:odd').addClass("odd").removeClass("even");
};

App.check_all_under = function(jquery_expr, check) {
  jQuery(":checkbox", jQuery(jquery_expr)).attr("checked", check);
  return false;
};

App.block_enter = function(x) {
  Event.observe(x, 'keypress', function(event){
    App.DebugConsole.log(["block_enter", event.keyCode]);
    if (event.keyCode == Event.KEY_RETURN) {
      var elem = Event.element(event);
      if (!elem) return;
      if (elem.tagName.match(/^(A|TEXTAREA)$/)) return;
      if (elem.tagName == 'INPUT' && elem.type.match(/^(button|submit)$/)) return;
      Event.stop(event);
    }
  });
};

// set aliases of some functions used frequently
var onAjaxLink = App.onAjaxLink;
var closeView = App.closeView;
var onMenu = App.onMenu;


var Rfw = {
  parseExpression: function(expr) {
    if (!expr.match(/^[A-Za-z0-9_]+$/)) {
      return null;
    }
    var s = [];
    var e = expr;
    var m;
    while (e.length > 0) {
      if ( (m = e.match(/^[A-Za-z0-9]+/)) ) {
        s.push(m[0]);
        e = e.substr(m[0].length);
      } else {
        e = e.substr(1);
      }
    }
    return s;
  },
  parseId: function(id) {
    App.DebugConsole.log(['parseId', id]);
    return id.match(/^rfw_/) && Rfw.parseExpression(id.substr(4));
  },
  isRfw: function(x) {
    return x.nodeName == 'DIV' && Rfw.parseId(x.id);
  },

  expression: function() {
    if (this.id == 'rfw') return null;
    return this.id.substr(4);
  },
  expressionSequence: function() {
    var expr = this.expression();
    return expr && Rfw.parseExpression(expr);
  },
  nextExpression: function(expr) {
    var n = 0;
    if (expr) {
      while ($('rfw_' + expr + '_' + n)) {
        n++;
      }
      return (expr + '_' + n);
    } else {
      while ($('rfw_' + n)) {
        n++;
      }
      return n.toString();
    }
  },
  ancestor: function() {
    var a = this.up();
    while (!Rfw.isRfw(a)) {
      a = a.up();
      if (a.nodeName == 'BODY') {
        a = $('rfw');
        break;
      }
    }
    return a;
  },
  relative: function(stub, num) {
    var a;
    var x = (num > 0) ? this.up(num-1) : this;
    if (stub == 'ancestor') {
      a = Rfw.ancestor.bind(x)();
    } else if (stub == 'sibling') {
      while ( x && !(a = x.siblings().detect(Rfw.isRfw)) ) {
        x = x.up();
        if (x.nodeName == 'BODY') break;
      }
    } else {
      alert('Rfw.relative: unknown stub: ' + stub);
      return a;
    }
    return a || $('rfw');
  },
  callerId: function() {
    var id = 'rfw';
    var callee = Rfw.ancestor.bind(this)();
    App.DebugConsole.log(['callee', callee]);
    if (callee) {
      id = callee.classNames().detect(Rfw.parseId);
      return id || Rfw.callerId.bind(callee)();
    }
    App.DebugConsole.log(['id', id]);
    return id;
  },
  caller: function() {
    var id = Rfw.callerId.bind(this)();
    return $(id);
  },
  calleeId: function() {
    var id = 'rfw';
    var parent = Rfw.ancestor.bind(this)();
    if (parent) {
      id = parent.classNames().detect(Rfw.parseId);
      if (id) {
        return parent.id;
      } else {
        return Rfw.calleeId.bind(parent)();
      }
    }
    return id;
  },
  create: function(id, mark) {
    var div = new Element('div');
    div.id = id;
    div.addClassName('rfw');
    div.addClassName('popup');
    div.addClassName('view');
    div.addClassName('picker_shadow');
    var className = null;
    if (mark) {
      var caller = Rfw.ancestor.bind(this)();
      if (caller) {
        className = caller.id;
      }
    }
    if (className) div.addClassName(className);
    div.hide();
    return div;
  },

  findOrInsert: function(seed, stub, num, mark) {
    var relative = Rfw.relative.bind(this)(stub, num);
    if (!relative) return false;
    var rexpr = Rfw.expression.bind(relative)();
    var expr = (seed == '*') ? Rfw.nextExpression(rexpr) : ((rexpr) ? (rexpr + seed) : seed);
    var s = Rfw.parseExpression(expr);
    if (!s) {
      App.DebugConsole.log('Rfw.findOrInsert: parse error: ' + expr);
      return false;
    }
    var id = 'rfw_' + expr;
    if (!$(id)) {
      var e;
      while (s.length > 0) {
        s.length -= 1;
        e = s.join('_');
        if ($('rfw_' + e)) {
          var div = Rfw.create.bind(this)(id, mark);
          $('rfw_' + e).insert({top: div});
          break;
        }
      }
      if (!$(id)) {
        var div = Rfw.create.bind(this)(id, mark);
        $('rfw').insert({top: div});
      }
    }
    return id;
  },
  open: function(e) {
    var args = $A(arguments);
    var id;
    var url  = args[1];
    var seed = args[2];
    if (seed) {
      var stub = args[3];
      var num  = args[4];
      id = Rfw.findOrInsert.bind(this)(seed, stub, num);
      if (!id) return false;
    } else {
      id = Rfw.callerId.bind(this)();
      $(id).hide();
    }
    var options = {
      app_view: $(id),
      onComplete: function() {
        $(id).show();
        /* new Effect.Highlight(id,{duration:0.5, queue:{scope:"Rfw.pick",limit:2,position:"end"}}); */
      }
    };
    new Ajax.Updater(id, url, options);
  },
  close: function(e) {
    var calleeId = Rfw.calleeId.bind(this)();
    if (calleeId) {
      (function() {
        var callee = $(calleeId);
        if (callee) callee.remove();
        $$('div.' + calleeId).invoke('remove');
        App.DocumentLayout.updateTitle();
      }).defer();
    }
  },
  submit: function(e) {
    var form = $(this.form);
    var args = $A(arguments);
    var url  = args[1] || form.action;
    var seed = args[2];
    var data = form.serialize();
    form.getInputs('submit').invoke('disable');
    form.getInputs('button').invoke('disable');
    var id;
    if (seed) {
      var stub = args[3];
      var num  = args[4];
      var mark = args[5];
      id = Rfw.findOrInsert.bind(this)(seed, stub, num, mark);
      if (!id) return false;
    } else {
      var ancestor = Rfw.ancestor.bind(this)();
      id = ancestor.id;
    }
    new Ajax.Updater(id, url, {
      parameters: data,
      app_view: $(id),
      onComplete: function() {
        $(id).show();
      }
    });
  },
  embedHiddenParameters: function(e, x) {
    var form = $(this.form);
    $H(x).each(function(pair) {
      var name = 'rfw[' + pair.key + ']';
      var x = form.select('input[name="' + name + '"]');
      if (x.size() == 0) {
        var input = new Element('input');
        input.type = 'hidden';
        input.name = name;
        input.value = pair.value;
        form.insert(input);
      } else {
        var input = x.first();
        input.value = pair.value;
      }
    });
  },
  pick: function(e, x, message) {
    if (message) {
      if (!confirm(message)){
        return;
      }
    }
    var caller = Rfw.caller.bind(this)();
    var calleeId = Rfw.calleeId.bind(this)();
    if (!caller || !calleeId) {
      Rfw.close.bind(this)();
      return;
    }
    var form = caller.select('form').detect(function(f) {return !f.descendantOf(calleeId)});
    if (form) {
      var f = function(v) {
        if (v) {
          $H(v).each(function(pair) {
            var inputs = form.select('input[name="' + pair.key + '"]');
            var input = inputs.first();
            if (input) {
              var val;
              if (typeof pair.value == 'string' && pair.value.match(/^\(function/)){
                var fun;
                eval('fun='+pair.value);
                val = fun();
              } else {
                val = pair.value;
              }
              switch (input.type) {
              case 'radio':
              case 'checkbox':
                  inputs.each(function(i) {i.checked = (i.value == val)});
                  break;
              default:
                  input.value = val;
                  break;
              }
            } else {
              App.DebugConsole.log('Rfw.pick: input of name "' + pair.key + '" not found');
            }
          });
        }
        form.getInputs('button').invoke('enable');
        form.getInputs('submit').invoke('enable');
        /* new Effect.Highlight(form,{duration:0.5, queue:{scope:"Rfw.pick",limit:2,position:"end"}}); */
      };
      if (this.nodeName == 'A') {
        f(x);
        Rfw.close.bind(this)();
      } else if (this.nodeName == 'INPUT') {
        var form1 = $(this.form);
        var url  = x || form1.action;
        var data = form1.serialize();
        form1.getInputs('submit').invoke('disable');
        form1.getInputs('button').invoke('disable');
        new Ajax.Request(url, {
          parameters: data,
          onSuccess: function(transport) {
            f(transport.responseText.evalJSON());
          },
          onComplete: Rfw.close.bind(this)
        });
      }
    }
  },
  cancelPicker: function(e) {
    var caller = Rfw.caller.bind(this)();
    var calleeId = Rfw.calleeId.bind(this)();
    if (caller && calleeId) {
      var form = caller.select('form').detect(function(f) {return !f.descendantOf(calleeId)});
      if (form) {
        form.getInputs('button').invoke('enable');
        form.getInputs('submit').invoke('enable');
      }
    }
    Rfw.close.bind(this)();
  },
  pickAsElement: function(e, x, target, template) {
    var t = new Template(template);
    App.DebugConsole.log(['pickAsElement:x', x, target]);
    var elements = x.map(function(h){ return t.evaluate(h); });
    var temp = new Element('ul').insert(elements.join("\n"));
    elements = temp.childElements();
    var ids = target.childElements().map(function(e){
      return $w(e.className);
    }).flatten();
    elements = elements.reject(function(e){
      return ids.any(function(id){ return e.hasClassName(id); });
    });
    elements.each(function(elem){
      target.insert(elem);
    });
  },
  showMailInfo: function(seed){
    App.DebugConsole.log(['show_mail_info', seed]);
    var mail_info = $('mail_info_' + seed);
    var mail_send_button = $('mail_send_' + seed);
    if (mail_info) {
      mail_info.hide();
      mail_info.childElements().each(function(elem, index){ elem.remove(); });
      var target = $$('div#mail_form_' + seed + ' input[name*=recipients]').first();
      var ids = target.value.split(',').reject(function(v){ return v.empty(); });
      target = $$('div#mail_form_' + seed + ' input[name*=names]').first();
      var names = target.value.split(',').reject(function(v){ return v.empty(); });
      App.DebugConsole.log([ids, names]);
      $('mail_num_' + seed).value = ids.size();
      ids.zip(names).each(function(element){
        mail_info.insert((new Element('option', {value:element[0]})).update(element[1]));
      });
      if (ids.size() > 0) {
        mail_info.show();
        if (mail_send_button) {
          mail_send_button.enable();
        }
      } else {
        mail_info.hide();
        if (mail_send_button) {
          mail_send_button.disable();
        }
      }
    }
  },
  combine: function() {
    var x = $A(arguments);
    return function() {return x.invoke('apply', this, arguments).last();};
  }
};


var Hack = {
  replace_link: function(sub_view) {
    var currentMarkerNode = jQuery("div#" + sub_view);
    var currentTabPane    = currentMarkerNode.parent().parent();
    var selectedTab       = currentMarkerNode.parent();
    var form = currentMarkerNode.siblings("form");
    form.append("<input type=\"hidden\" value=\"" + selectedTab.attr("id") + "\" name=\"tab_id\"");
    jQuery("a.button", currentTabPane).each(function(i, elem){
      if (elem.href.match(/\/show\//)){
        elem.href = elem.href.replace(/\/show\//, "/show_only/");
        elem.href += "?tab_id=" + selectedTab.attr("id");
      }
    });
  },
  unique_error_messages: function() {
    jQuery("table#details_table > tbody > tr > td.input_item").each(function(i, elem) {
      if (jQuery("input", elem).length > 1) {
        var e = jQuery("div.formError", elem);
        var m = e.slice(0,1).text();
        jQuery("div.fieldWithErrors", elem).css("display", "inline");
        jQuery("div.fieldWithErrors + label", elem).css("background", "#f9c");
        elem.insert("<br /><div class=\"formError\">"+ m +"</div>");
        e.hide();
      }
    });
  }
};
