# -*- coding: utf-8 -*-
# 税額を計算するためのモジュール
module TaxCalculation
  # 税抜き金額から税込み金額と税額を計算する
  def self.compute_gross_of_tax(amount, account_item_id, accrual_date)
    account_item = AccountItem.find(account_item_id)
    tax_rate = TaxRate.find_by_accrual_date(accrual_date)
    unless tax_rate.nil?
      tax_rate = tax_rate.tax_rate
    else
      return [amount, 0]
    end
    if account_item.compute_tax?
      [(amount * (1 + tax_rate)).ceil, (amount * tax_rate).floor]
    else
      [amount, 0]
    end
  end

  # 税込み金額から税抜き金額を計算する
  def self.compute_net_of_tax(amount, account_item_id, accrual_date)
    account_item = AccountItem.find(account_item_id)
    tax_rate = TaxRate.find_by_accrual_date(accrual_date)
    unless tax_rate.nil?
      tax_rate = tax_rate.tax_rate
    else
      return amount
    end
    if account_item.compute_tax?
      (amount / (1 + tax_rate)).ceil
    else
      amount
    end
  end
end
