namespace :workflow do
  namespace :maintenance do
    desc "sync companies, organizations and people."
    task :sync => :environment do
      domain_id = ENV['DOMAIN_ID']
      domains = Domain.find(:all,:conditions => { :id => domain_id })
      darr = domains.map do |domain|
        d = WorkflowStruct::Domain.new
        WorkflowStruct::Domain::STRUCT_MEMBERS.each do |name,|
          d.__send__("#{name}=", domain.__send__(name))
        end
        d
      end
      companies = Company.find(:all,:conditions => { :domain_id => domain_id })
      carr = companies.map do |company|
        c = WorkflowStruct::Company.new
        WorkflowStruct::Company::STRUCT_MEMBERS.each do |name,|
          c.__send__("#{name}=", company.__send__(name))
        end
        c
      end
      organizations = Organization.find_with_period(:all,:conditions => { :domain_id => domain_id })
      oarr = organizations.map do |organization|
        o = WorkflowStruct::Organization.new
        WorkflowStruct::Organization::STRUCT_MEMBERS.each do |name,|
          case name
          when :inception, :expiry
            o.__send__("#{name}=", organization.attributes[name.to_s])
          else
            o.__send__("#{name}=", organization.__send__(name))
          end
        end
        o
      end
      people = Person.find(:all,:conditions => { :domain_id => domain_id })
      parr = people.map do |person|
        p = WorkflowStruct::Person.new
        WorkflowStruct::Person::STRUCT_MEMBERS.each do |name,|
          p.__send__("#{name}=", person.__send__(name))
        end
        p
      end

      users = User.find(:all,:conditions=>{:admin => true , :domain_id => domain_id})
      uarr = users.map do |user|
        usr = WorkflowStruct::User.new
        WorkflowStruct::User::STRUCT_MEMBERS.each do |name,|
          usr.__send__("#{name}=", user.__send__(name))
        end
        usr
      end

      company_members = CompanyMember.find_with_period(:all,:conditions => { :domain_id => domain_id })
      cmarr = company_members.map do |member|
        cm = WorkflowStruct::CompanyMember.new
        WorkflowStruct::CompanyMember::STRUCT_MEMBERS.each do |name,|
          case name
          when :inception, :expiry
            cm.__send__("#{name}=", member.attributes[name.to_s])
          else
            cm.__send__("#{name}=", member.__send__(name))
          end
        end
        cm
      end
      organization_members = OrganizationMember.find_with_period(:all,:conditions => { :domain_id => domain_id })
      omarr = organization_members.map do |member|
        om = WorkflowStruct::OrganizationMember.new
        WorkflowStruct::OrganizationMember::STRUCT_MEMBERS.each do |name,|
          case name
          when :inception, :expiry
            om.__send__("#{name}=", member.attributes[name.to_s])
          else
            om.__send__("#{name}=", member.__send__(name))
          end
        end
        om
      end
      posts = Post.find(:all,:conditions => { :domain_id => domain_id})
      psarr = posts.map do |post|
        ps = WorkflowStruct::Post.new
        WorkflowStruct::Post::STRUCT_MEMBERS.each do |name,|
          ps.__send__("#{name}=", post.__send__(name))
        end
        ps
      end

      endpoint = ENV["WORKFLOW_ENDPOINT"] || "http://localhost:3001/workflow/maintenance"
      client = ActionWebService::Client::Soap.new(WorkflowMaintenanceApi, endpoint)
      response = client.sync(darr, carr, oarr, parr,uarr, cmarr, omarr,psarr)
      print "#{response.status}\n"
      if response.failure?
        print "#{response.information}\n"
      end
    end
  end
  desc "install system data"
  task :install => :environment do
    domain_id = ENV['DOMAIN_ID']
    languages = Language.find(:all)
    po_ids = Array.new
    larr = languages.map do |language|
      po_ids << language.name_po
      ln = WorkflowStruct::LanguageInfo.new
      WorkflowStruct::LanguageInfo::STRUCT_MEMBERS.each do |name,|
        ln.__send__("#{name.to_s}=", language.__send__(name.to_s))
      end
      ln
    end

    po_messages = PoMessage.find(:all,:conditions => { :id => po_ids, :domain_id => domain_id })
    marr =  po_messages.map do |po_message|
      msg = WorkflowStruct::PoMessage.new
      WorkflowStruct::PoMessage::STRUCT_MEMBERS.each do |name,|
        msg.__send__("#{name}=", po_message.__send__(name))
      end
      msg
    end

    po_translations = PoTranslation.find(:all, :conditions => { :po_message_id => po_ids , :domain_id => domain_id})
    tarr = po_translations.map do |po_translation|
      trn = WorkflowStruct::PoTranslation.new
      WorkflowStruct::PoTranslation::STRUCT_MEMBERS.each do |name,|
        trn.__send__("#{name}=", po_translation.__send__(name))
      end
      trn
    end

    sys = WorkflowStruct::System.new
    sys.languages = larr
    sys.po_messages = marr
    sys.po_translations = tarr

    endpoint = ENV["WORKFLOW_ENDPOINT"] || "http://localhost:3001/workflow/system"
    client = ActionWebService::Client::Soap.new(WorkflowSystemApi, endpoint)
    response = client.update(sys)
    print "#{response.status}\n"
    if response.failure?
      print "#{response.information}\n"
    end
  end
end
