require "csv"

desc "Dump database schema to csv"
namespace :db do
  namespace :schema do
    namespace :csv do
      task :dump => :environment do
        SHEET_SEPARATOR = "%"
        HEADER = ["カラム名", "値の型", "桁数", "NOT NULL", "UNIQUE", "既定値", "摘要", "備考"]
        SUMMARY = {
          :id => "ID",
          :type => "モデルの型",
          :domain_id => "ドメイン",
          :code => "コード",
          :name => "名前",
          :name_po => "名前の po message の ID",
          :position => "位置",
          :parent_id => "親の ID",
          :lft => "NestedSet 構造での左端",
          :rgt => "NestedSet 構造での右端",
          :inception => "有効期間開始日付",
          :expiry => "有効期間終了日付",
          :created_at => "作成日時",
          :updated_at => "更新日時",
          :created_by => "作成者",
          :updated_by => "更新者",
          :created_in => "作成画面",
          :updated_in => "更新画面",
        }
        REMARK = {
          :created_by => "users テーブルの id の値",
          :updated_by => "users テーブルの id の値",
          :created_in => "displays テーブルの id の値",
          :updated_in => "dipslays テーブルの id の値",
        }
        possible_values = lambda do |options|
          "有効な値: " + options.map {|x| "'#{x}'"}.join(", ")
        end
        REMARK_MESSAGE_CSS = "'px', 'em' などの CSS で利用する単位を含める。"
        TABLE = [
                 [:attachments,
                  "添付ファイルの情報を格納する。",
                  {
                    :description => "ファイルの説明",
                  }, {
                  }],
                 [:binary_objects,
                  "添付ファイルをデータベースに保存する場合に利用する。",
                  {
                    :mime_type => "ファイルの MIME TYPE",
                    :content => "データ",
                    :length => "データの長さ",
                  }, {
                    :length => "byte 単位",
                  }],
                 [:cells,
                  "view で格子状のレイアウトを実現するために単位となるセルの情報を格納する。",
                  {
                    :height => "高さ",
                  }, {
                    :height => REMARK_MESSAGE_CSS,
                  }],
                 [:companies,
                  "企業の情報を格納する。",
                  {
                  }, {
                  }],
                 [:company_members,
                  "企業に所属する個人の情報を格納する。",
                  {
                  }, {
                  }],
                 [:config_attachments,
                  "添付ファイル機能についてのドメインごとの設定を格納する。",
                  {
                    :default_file_type => "既定のファイルの保存先",
                    :maximum_length => "アップロード可能なファイルの最大サイズ(byte)",
                  }, {
                    :default_file_type => "'BinaryObject'(データベース) または 'StorageObject'(ファイルシステム)"
                  }],
                 [:config_output_items,
                  "config_outputs テーブルに関連して、ファイル生成の対象になる項目の情報を格納する。",
                  {
                    :enabled => "有効かどうか",
                  }, {
                  }],
                 [:config_outputs,
                  "一覧をファイル生成するための設定の情報を格納する。",
                  {
                    :file_format => "出力するファイル形式",
                    :eol_pattern => "行末文字のパターン",
                    :eol_parameter => "行末文字のパラメータ",
                    :separator_pattern => "区切り文字のパターン",
                    :separator_parameter => "区切り文字のパラメータ",
                    :quotation_pattern => "クオート文字のパターン",
                    :quotation_parameter => "クオート文字のパラメータ",
                    :encoding => "(CSV 形式の)文字エンコーディング",
                  }, {
                    :file_format => possible_values.call(ConfigOutput::LABEL_FILE_FORMAT.map(&:last)),
                    :eol_pattern => possible_values.call(ConfigOutput::LABEL_EOL_PATTERN.map(&:last)),
                    :separator_pattern => possible_values.call(ConfigOutput::LABEL_SEPARATOR_PATTERN.map(&:last)),
                    :quotation_pattern => possible_values.call(ConfigOutput::LABEL_QUOTATION_PATTERN.map(&:last)),
                    :encoding => possible_values.call(ConfigOutput::LABEL_ENCODING.map(&:last)),
                  }],
                 [:config_passwords,
                  "パスワードについてドメインごとの設定を格納する。",
                  {
                    :min_length => "最小の長さ",
                    :enable_max_age => "有効期限のチェックを実施するかどうか",
                    :max_age => "有効期限日数",
                    :enable_min_age => "変更不可期間のチェックを実施するかどうか",
                    :min_age => "変更不可期間",
                    :enforce_change => "変更を要求するかどうか",
                    :enable_lockout => "ログイン失敗回数で資格失効するかどうか",
                    :lockout_threshold => "資格失効ログイン失敗回数",
                    :operator_screen_name => "操作画面名",
                  }, {
                    :min_length => "byte 単位",
                    :max_age => "日数",
                    :min_age => "日数",
                  }],
                 [:counters,
                  "「サーバサイド部品」の「ナンバリング部品」で利用する。",
                  {
                    :table_name => "テーブル名",
                    :current_number => "現在の数値",
                  }, {
                  }],
                 [:displays,
                  "画面の情報を格納する。",
                  {
                    :enabled => "有効かどうか",
                    :button_new => "新規作成ボタン",
                    :button_edit => "編集ボタン",
                    :button_delete => "削除ボタン",
                    :button_copy => "複写ボタン",
                    :logic_path => "ビジネスロジックを記述したソースファイルへのパス",
                    :logic_pre => "ビジネスロジックの事前処理を有効にするかどうか",
                    :logic_post => "ビジネスロジックの事後処理を有効にするかどうか",
                  }, {
                    :type => possible_values.call(%w|DisplayToEdit DisplayToList DisplayToNew DisplayToShow|),
                  }],
                 [:documents,
                  "関連文書の情報を格納する。",
                  {
                    :mutual => "相互に関連付けるかどうか",
                  }, {
                  }],
                 [:domains,
                  "ドメインの情報を格納する。",
                  {
                  }, {
                  }],
                 [:grant_ons,
                  "権限を設定するための情報を格納する。\n(実際に権限が参照される際には permissions テーブルが利用される。)",
                  {
                    :value => "権限の値",
                  }, {
                    :value => possible_values.call(%w|invisible visible full|),
                  }],
                 [:group_members,
                  "グループに所属する個人の情報を格納する。",
                  {
                  }, {
                  }],
                 [:groups,
                  "グループの情報を格納する。",
                  {
                  }, {
                  }],
                 [:holidays,
                  "休日の情報を格納する。",
                  {
                    :year => "年",
                    :month => "月",
                    :day => "日",
                  }, {
                  }],
                 [:input_options,
                  "input の選択肢の情報を格納する。",
                  {
                    :category => "選択肢のカテゴリー",
                    :value => "選択肢の値",
                  }, {
                  }],
                 [:items,
                  "画面に表示される項目の情報を格納する。",
                  {
                    :column_name => "カラム名\n(NULL なら疑似項目)",
                    :adapter_name => "(疑似項目の場合)\nモジュール名",
                    :layout => "レイアウト",
                    :width => "横幅",
                    :align => "位置揃え",
                    :decorator => "装飾",
                    :decorator_parameter => "装飾のパラメータ",
                    :linked => "リンクするかどうか",
                    :link_parameter => "リンクのパラメータ",
                    :direction => "昇降順",
                    :condition_value => "検索条件の値",
                    :condition_pattern => "検索条件の種類",
                    :selected => "(個人一覧画面の場合)表示されるかどうか\n(HeaderDetail形式の場合)抽出キーかどうか",
                    :ordered => "(Obsoleted: 並び替えるかどうか)",
                    :search => "汎用検索で利用できるかどうか",
                    :control => "権限制御",
                    :input_type => "入力のタイプ",
                    :field_size => "入力欄のサイズ",
                    :input_parameter => "入力のパラメータ",
                    :input_initializer => "入力初期化子",
                    :input_initial_value => "入力初期値",

                    :validates_presence             => "存在チェック",
                    :validates_non_negative_integer => "非負整数チェック",
                    :validates_integer              => "整数チェック",
                    :validates_non_negative_float   => "非負小数チェック",
                    :validates_float                => "小数チェック",
                    :validates_zero                 => "ゼロチェック",
                    :validates_upper_case           => "英字大文字チェック",
                    :validates_lower_case           => "英字小文字チェック",
                    :validates_alphabetic           => "英字チェック",
                    :validates_alphanumeric         => "半角英数チェック",
                    :validates_halfwidth_katakana   => "半角カナチェック",
                    :validates_fullwidth            => "全角チェック",
                    :validates_fullwidth_katakana   => "全角カナチェック",
                    :validates_inclusion_chars      => "指定文字チェック",
                    :validates_minimum_length       => "最小桁数チェック",
                    :validates_maximum_length       => "最大桁数チェック",
                    :validates_integral_length      => "数字論理桁数チェック",
                    :validates_fractional_length    => "小数論理桁数チェック",
                    :validates_year                 => "年チェック",
                    :validates_year_month           => "年月チェック",
                    :validates_year_month_day       => "年月日チェック",
                    :validates_hour                 => "時チェック",
                    :validates_hour_minute          => "時分チェック",
                    :validates_postal_code          => "郵便番号チェック",
                    :validates_phone_number         => "電話番号チェック",
                    :validates_email                => "メールアドレスチェック",
                    :validates_url                  => "URL チェック",
                    :validates_minimum_number       => "数字大小関係チェック",
                    :validates_period               => "日付FromToチェック",
                    :validates_future_date          => "日付当日より未来チェック",
                    :validates_past_date            => "日付当日より過去チェック",
                    :validates_uniqueness           => "一意性チェック",
                    :validates_row                  => "テーブル内項目存在チェック",

                    :validates_minimum_length_1 => "最小桁数",
                    :validates_maximum_length_1 => "最大桁数",
                    :validates_integral_length_1 => "数字論理桁数の最小値",
                    :validates_integral_length_2 => "数字論理桁数の最大値",
                    :validates_fractional_length_1 => "小数論理桁数の最小値",
                    :validates_fractional_length_2 => "小数論理桁数の最大値",
                    :validates_minimum_number_1 => "最小基準値",
                    :validates_period_1 => "開始日",
                    :validates_period_2 => "終了日",
                    :validates_row_1 => "テーブル名",
                    :validates_row_2 => "カラム名",
                  }, {
                    :width => REMARK_MESSAGE_CSS,
                    :type => possible_values.call(%w|ItemProper ItemPseudo|),
                    :align => possible_values.call(%w|left center right|),
                    :decorator => possible_values.call(Item::LABEL_DECORATOR.map(&:last)),
                    :condition_pattern => possible_values.call(Item::LABEL_CONDITION_PATTERN.map(&:last)),
                    :direction => possible_values.call(Item::LABEL_DIRECTION.map(&:last)),
                    :control => possible_values.call(Item::LABEL_CONTROL.map(&:last)),
                    :input_type => possible_values.call(Item::LABEL_INPUT_TYPE.map(&:last)),
                    :field_size => "input タグの size 属性に指定する値",
                    :input_parameter => "(checkbox の場合)選択できる値\n" + "(選択部品の場合)" + possible_values.call(%w|company organization person post group calendar|),
                    :input_initializer => possible_values.call(Item::LABEL_INPUT_INITIALIZER.map(&:last)),
                    :validates_inclusion_chars_1 => "含まれることが許される文字すべてを文字列で与える",
                  }],
                 [:languages,
                  "多言語対応でサポートされる言語の情報を格納する。",
                  {
                  }, {
                  }],
                 [:login_histories,
                  "ログイン履歴の情報を格納する。",
                  {
                    :login => "ログイン名",
                    :password => "パスワード",
                    :result => "ログイン結果",
                    :remote_address => "リモート IP アドレス",
                    :program_type => "プログラムの種類",
                  }, {
                    :result => possible_values.call((LoginHistory::RESULTS - [:RESULT_MAX]).map {|r| "#{"LoginHistory::#{r}".constantize} (#{r})"}),
                  }],
                 [:mail_formats,
                  "「メール送信機能」のテンプレートの情報を格納する。",
                  {
                    :mail_mode => "メールモード",
                    :from_format => "送信者名",
                    :recipients_format => "宛先",
                    :subject_format => "件名",
                    :body_format => "本文",
                  }, {
                  }],
                 [:mail_histories,
                  "「メール送信機能」による送信履歴の情報を格納する。",
                  {
                    :from_value => "送信者",
                    :recipient_value => "宛先",
                    :subject => "件名",
                    :body => "本文",
                    :status => "状態",
                    :error_log => "エラーログ",
                  }, {
                    :status => possible_values.call(["NULL (送信が完了していない、もしくはエラーの場合)", "'delivered' (送信が完了した場合)"]),
                  }],
                 [:mail_queues,
                  "「メール送信機能」の送信キューの情報を格納する。",
                  {
                    :recipient_ids => "受信者",
                    :comment_message => "コメント",
                    :field_type => "送信方法",
                    :has_attachment => "添付ありかどうか",
                    :auto_login_url => "オートログイン URL",
                    :mail_mode => "メールモード",
                    :copy_to_sender => "送信者にも送るかどうか",
                    :processed => "処理済みかどうか",
                  }, {
                  }],
                 [:matters,
                  "(試験的)案件の情報を格納する。",
                  {
                  }, {
                  }],
                 [:organization_members,
                  "組織に所属する個人の情報を格納する。",
                  {
                  }, {
                  }],
                 [:organizations,
                  "組織の情報を格納する。",
                  {
                  }, {
                  }],
                 [:panes,
                  "view で格子状のレイアウトを実現するために、縦の列の情報を格納する。",
                  {
                    :width => "横幅",
                  }, {
                    :width => REMARK_MESSAGE_CSS,
                  }],
                 [:people,
                  "個人の情報を格納する。",
                  {
                    :mail_address => "メールアドレス",
                    :last_language => "設定された言語",
                    :default_company_id => "既定の企業",
                    :default_organization_id => "既定の組織",
                    :default_post_id => "既定の役職",
                  }, {
                    :last_language => "2文字の言語コード",
                  }],
                 [:permissions,
                  "フレームワークが権限を参照する際に利用する。\n各行は grant_ons テーブルに格納されている行に由来する。",
                  {
                    :priority => "優先度",
                    :value => "権限の値",
                  }, {
                    :priority => possible_values.call((Membership::PRIORITIES - [:PRIORITY_SENTINEL]).map {|r| "#{"Membership::#{r}".constantize} (#{r})"}),
                    :value => possible_values.call(%w|invisible visible full|),
                  }],
                 [:po_arguments,
                  "多言語対応のためのライブラリ gettext で利用する。\nデータベースに格納されている文字列を翻訳するために利用する。",
                  {
                    :value => "パラメータの値",
                  }, {
                  }],
                 [:po_messages,
                  "多言語対応のためのライブラリ gettext で利用する。\nデータベースに格納されている文字列を翻訳するために利用する。",
                  {
                    :msgid => "翻訳対象のキー",
                    :msgid_plural => "翻訳対象の複数形",
                  }, {
                    :type => possible_values.call(%w|PoMessageSingular PoMessagePlural|),
                  }],
                 [:po_translations,
                  "多言語対応のためのライブラリ gettext で利用する。\nデータベースに格納されている文字列を翻訳するために利用する。",
                  {
                    :msgstr => "翻訳結果の文字列",
                    :msgstr_0 => "(複数形に依存する場合)翻訳結果の文字列0",
                    :msgstr_1 => "(複数形に依存する場合)翻訳結果の文字列1",
                    :msgstr_2 => "(複数形に依存する場合)翻訳結果の文字列2",
                    :msgstr_3 => "(複数形に依存する場合)翻訳結果の文字列3",
                    :msgstr_4 => "(複数形に依存する場合)翻訳結果の文字列4",
                    :msgstr_5 => "(複数形に依存する場合)翻訳結果の文字列5",
                  }, {
                    :type => possible_values.call(Language.all.map {|lang| "PoMessage#{lang.code.camelize}"}),
                  }],
                 [:portals,
                  "ユーザーごとのポータルの情報を格納する。",
                  {
                    :pattern => "レイアウトのパターン",
                  }, {
                    :pattern => possible_values.call(Portal::LABEL_PATTERN.map(&:last)),
                  }],
                 [:portlet_configs,
                  "(予定)ポートレットの設定の情報を格納する。",
                  {
                    :name => "設定項目の名前",
                    :value => "設定項目の値",
                  }, {
                  }],
                 [:portlets,
                  "ポータルに載るポートレットの情報を格納する。",
                  {
                  }, {
                  }],
                 [:portlettable_groups,
                  "ポートレッタブル(ポートレットとして動作する対象)のグループの情報を格納する。",
                  {
                    :category => "カテゴリー",
                  }, {
                    :category => possible_values.call(%w|S M L|),
                  }],
                 [:portlettable_members,
                  "ポートレッタブルの情報を格納する。",
                  {
                    :category => "カテゴリー",
                  }, {
                    :category => possible_values.call(%w|S M L|),
                  }],
                 [:posted_tos,
                  "役職の割り当て情報を格納する。",
                  {
                  }, {
                  }],
                 [:posts,
                  "役職の情報を格納する。",
                  {
                  }, {
                  }],
                 [:products,
                  "機能の情報を格納する。",
                  {
                    :motion => "動作",
                    :table_name => "テーブル名",
                    :workflow_enabled => "ワークフローが有効かどうか",
                    :workflow => "ワークフロー",
                    :mail => "メールが有効かどうか",
                    :mail_skip_auth => "メールの URL を開く際に認証を省くかどうか",
                    :document => "関連文書を有効にするかどうか",
                    :document_name_method => "文書名メソッド",
                    :document_number_method => "文書番号メソッド",
                    :document_content_method => "文書内容メソッド",
                    :attachments => "添付ファイルが有効かどうか",
                    :search => "検索が有効かどうか",
                    :csv => "CSV が有効かどうか",
                    :initial_roleable_type => "データ権限初期値",
                    :scope_roleable_type => "データ閲覧範囲型初期値",
                  }, {
                    :type => possible_values.call(%w|ProductSingle ProductM ProductL ProductPseudo|),
                    :table_name => "小文字で指定する",
                    :workflow => "(未定)",
                    :document_name_method => "ドキュメントのモデルで文書名を表すメソッド名を指定する",
                    :document_number_method => "ドキュメントのモデルで文書番号を表すメソッド名を指定する",
                    :document_content_method => "ドキュメントのモデルで文書内容を表すメソッド名を指定する",
                    :initial_roleable_type => possible_values.call(%w|Person Group Organization Company Domain|),
                    :scope_roleable_type => possible_values.call(%w|Person Group Organization Company Domain|),
                  }],
                 [:screens,
                  "view で格子状のレイアウトを実現するために画面の情報を格納する。",
                  {
                  }, {
                  }],
                 [:storage_objects,
                  "サーバ上に保存した添付ファイルの情報を格納する。",
                  {
                    :mime_type => "ファイルの MIME TYPE",
                    :uri => "ファイルの URI",
                    :length => "データの長さ",
                  }, {
                    :length => "byte 単位",
                  }],
                 [:storages,
                  "添付ファイルをサーバ上に格納するためのドメインごとの設定の情報を格納する。",
                  {
                    :root => "ファイルの保存先",
                    :separator => "パスの区切り文字",
                  }, {
                  }],
                 [:users,
                  "アプリケーションを利用するユーザーの情報を格納する。",
                  {
                    :login => "ログイン名",
                    :salted_password => "ハッシュされたパスワード",
                    :admin => "システム管理者かどうか",
                    :list_default_per_page => "一覧の1ページあたりのデフォルトの件数",
                    :list_header_per_line => "一覧項目の表示間隔",
                    :menu_history_max => "メニュー履歴保存数",
                    :salt => "ソルト",
                    :verified => "検証されているかどうか",
                    :security_token => "セキュリティトークン",
                    :token_expiry => "トークンの期限",
                    :deleted => "削除されているかどうか",
                    :failed_login_count => "連続ログイン失敗回数",
                    :password_updated_on => "パスワード更新日",
                  }, {
                  }],
                ]
        result = ""
        ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
        CSV::Writer.generate(result, ",", "\n") do |csv|
          TABLE.each do |table_name, table_description, table_content, table_remark|
            model_class = table_name.to_s.classify.constantize
            csv << [table_name]
            csv << [table_description]
            csv << []
            csv << HEADER
            columns = model_class.columns
            columns.each do |c|
              row = []
              name_sym = c.name.to_sym
              row << c.name
              row << c.type
              row << c.limit
              row << (c.null ? "" : "NOT NULL")
              row << (c.primary ? "UNIQUE" : "")
              row << c.default
              row << (table_content[name_sym] || SUMMARY[name_sym])
              remark = case c.name
                       when /_id\z/
                         if columns.map(&:name).include?("#{$`}_type")
                           "polymorphic な参照のID。"
                         else
                           "外部キー。"
                         end
                       when /_type\z/
                         if columns.map(&:name).include?("#{$`}_id")
                           "polymorphic な参照の型。"
                         else
                           ""
                         end
                       else
                       ""
                       end
              remark << (table_remark[name_sym] || REMARK[name_sym] || "")
              row << remark
              csv << row
            end
            csv << [SHEET_SEPARATOR]
          end
        end
        File.open("#{RAILS_ROOT}/doc/SCHEMA.csv", "wb") {|file| file.write result}
      end
    end
  end
end

