desc 'Dump a database to yaml fixtures'
namespace :db do
  namespace :fixtures do
    task :dump => :environment do
      path = ENV['FIXTURE_DIR'] || "#{RAILS_ROOT}/data"

      ActiveRecord::Base.establish_connection(RAILS_ENV.to_sym)
      Dir.foreach("test/fixtures") do |entry|
        if entry =~ /\.yml\z/
          table_name = $`
          model_class = table_name.classify.constantize
          File.open("#{path}/#{table_name}.yml", 'wb') do |file|
            model_class.find(:all, :order => "id").each do |record|
              file.puts "#{table_name}_#{record.id}:"
              model_class.column_names.each do |column_name|
                next if record[column_name].nil?
                file.puts "  #{column_name}: #{record[column_name].inspect}"
              end
            end
          end
        end
      end
    end
  end
end
