# PDF 文書のスタイルのモデル。
class SimpleCellStyle
  include DocumentStyles::StyleMargin
  include DocumentStyles::StyleAlignment
  include DocumentStyles::StyleBorderWidth

  def initialize(options={})
    # default value
    @color = {
      :border => DocumentStyles::Color.new(0, 0, 0),
      :text => DocumentStyles::Color.new(0, 0, 0),
      :fill => nil # can be nil (transparent)
    }
    @font_size = 12.0 # pt
    @line_height = 5.0 # mm

    # retrieve options
    options.each do |key,val|
      case(key)
      when :border_color
        if val.kind_of?(Array)
          @color[:border] = DocumentStyles::Color.new(val[0], val[1], val[2])
        elsif val.kind_of?(DocumentStyles::Color)
          @color[:border] = val
        else
          raise "Invalid color expression."
        end
      when :text_color
        if val.kind_of?(Array)
          @color[:text] = DocumentStyles::Color.new(val[0], val[1], val[2])
        elsif val.kind_of?(DocumentStyles::Color)
          @color[:text] = val
        else
          raise "Invalid color expression."
        end
      when :fill_color
        if val.kind_of?(Array)
          @color[:fill] = DocumentStyles::Color.new(val[0], val[1], val[2])
        elsif val.kind_of?(DocumentStyles::Color) || val == nil
          @color[:fill] = val
        else
          raise "Invalid color expression."
        end
      when :top_margin
        self.margin[:top] = val
      when :bottom_margin
        self.margin[:bottom] = val
      when :left_margin
        self.margin[:left] = val
      when :right_margin
        self.margin[:right] = val
      when :top_border_width
        self.border_width[:top] = val
      when :bottom_border_width
        self.border_width[:bottom] = val
      when :left_border_width
        self.border_width[:left] = val
      when :right_border_width
        self.border_width[:right] = val
      when :align
        self.align = val
      when :font_size
        @font_size = val
      when :line_height
        @line_height = val
      end
    end
  end

  attr_accessor :color, :font_size, :line_height
end
