# PDF 文書のテーブルのセルのモデル。
class SimpleCell
  def initialize(text, style=nil, link=nil)
    self.text = text
    @style = style ? style.dup : SimpleCellStyle.new
    @link = link ? link.dup : ""
  end

  # 行数。
  def line_num
    @text.size
  end

  # 行ごとに <em>block</em> を呼ぶ。
  def each_line(&block)
    @text.each(&block)
  end

  # <em>option[:array]</em> が真なら行ごとの配列、そうでなければ文字列を返す。
  def text(option={})
    option[:array] ? @text : @text.join("\n")
  end

  # <em>new_text</em> を格納する。
  def text=(new_text)
    @text = new_text.is_a?(Array) ? new_text : new_text.to_s.split(/\r?\n|\r/, -1)
  end

  attr_accessor :style, :link
end
