# -*- coding: utf-8 -*-
require 'readonly_helper'

# :readonly => true の場合 'readonly' という class も付与する。
module ReadonlyFormHelper

  def self.included(base)
    base.module_eval do
      alias_method_chain :text_field, :readonly
      alias_method_chain :text_area, :readonly
    end
  end

  def text_field_with_readonly(object_name, method, options={})
    text_field_without_readonly(object_name, method, ReadonlyHelper.options_with_readonly(options))
  end

  def text_area_with_readonly(object_name, method, options={})
    text_area_without_readonly(object_name, method, ReadonlyHelper.options_with_readonly(options))
  end

end

ActionView::Helpers::FormHelper.__send__(:include, ReadonlyFormHelper)
