# -*- coding: utf-8 -*-
# インスタンスに対する respond_to? で正しいことが仮定されるメッセージ:
# - id
# - input_parameter
module Picker
  RECORD_REGEXP = /\Arecord\(([^,]+)(?:,.+)?\)\z/

  # 汎用選択部品を使うかどうかを判定する。
  def picking_record?
    input_parameter =~ RECORD_REGEXP ? true : false
  end

  # 選択するキーたちを返す。
  # 適切なキーでなければ false を返す。
  def picked_keys
    return false if input_parameter.blank?
    if input_parameter =~ RECORD_REGEXP
      return [$1]
    end
    input_parameter.split(',')
  end

  # 選択する最小単位を返す。
  # 適切なキーがなければ false を返す。
  def picked_atom
    return false unless picked_keys
    return 'calendar' if /calendar/ === picked_keys.first # HACK
    return picked_keys[0] if picked_keys.size == 1
    # the order of the following array is significant.
    %w|person organization company post group|.each do |k|
      return k if picked_keys.include?(k)
    end
    return "lump" # FIXME
  end

  # 受け取ったハッシュからオブジェクトの配列を返す。
  def picked_values(x)
    picked_keys.map do |k|
      id = x[k.to_sym]
      model_class = k.classify.constantize
      id.blank? ? model_class.new : model_class.find_by_id(id)
    end
  end

  # 受け取ったオブジェクトから関連づいたオブジェクトの配列を返す。
  def picked_references(x)
    return [x] if picked_keys.size == 1
    case picked_atom
    when "person"
      return picked_keys.map {|k| k == "person" ? x : x.__send__("preferred_#{k}")}
    when "organization", "post"
      return picked_keys.map {|k| k == picked_atom ? x : x.__send__(k)}
    else
      raise ArgumentError, "invalid picked atom: #{picked_atom}"
    end
  end

  # controller で include される。
  module Controller
    def picker_model_class(source_name)
      ConfigPicker.model_class(controller_name, source_name)
    end
  end

  # helper で include される。
  module Helper
    def picker_model_class(controller_name, source_name)
      ConfigPicker.model_class(controller_name, source_name)
    end
  end

end
