# -*- coding: utf-8 -*-
module NarrowingCondition
  class ProjectRetrievalDivision
    include GetText

    bindtextdomain("database")

    attr_accessor :narrowing

    def initialize(narrowing)
      @narrowing = narrowing
    end

    # シンボルの配列を返す。
    def value_keys
      keys = (1..10).map {|i| :"project_retrieval_division_#{i}"}
      keys.push(:"project_retrieval_divisions")
      keys
    end

    def text(values)
      name = Array.new
      (1..10).map do |i|
        v = values[:"project_retrieval_division_#{i}"]
#        v.blank? ? s_("pjc|Project|(unspecified)") : v
        name << v unless v.blank?
      end
      name = name.join("-")
    end

    def condition(table_name, column_name)
      x = (1..10).map do |i|
        v = Narrowing.current(narrowing, "project_retrieval_division_#{i}")
        v.blank? ? nil : <<-SQL
retrieval_division_id#{i} IN
 (SELECT id FROM retrieval_divisions
   WHERE retrieval_division = #{narrowing.class.quote_value(i)}
     AND name LIKE '%#{narrowing.class.connection.quote_like(v, '\\')}%')
        SQL
      end.compact
      x.empty? ? nil : "#{table_name}.#{column_name} IN (SELECT id FROM projects WHERE #{x.join(' AND ')})"
    end

  end
end
