# -*- coding: utf-8 -*-

# 結合可能なタグ
class MergeableTag
  include ActionView::Helpers::TagHelper

  def initialize(kind, child, attr={})
    @kind = kind
    @child = child
    @attr = attr
  end

  attr_reader :kind, :child, :attr

  def to_s
    content_tag(kind, child, attr)
  end

  def merge(tag, separator=" ")
    if self.kind != tag.kind
      raise TypeError, "Type mismatch: #{self.kind} != #{tag.kind}"
    end
    @child << separator
    @child << tag.child
    @attr = self.attr.merge(tag.attr) do |key, self_val, tag_val|
      (key.to_s == "class") ? "#{self_val} #{tag_val}" : tag_val
    end
  end
end
