# -*- coding: utf-8 -*-
# 所属関係の変更に応じて <tt>GrantOn</tt> と <tt>Permission</tt> の同期を
# 行うための Observer を実装している。
class Membership

  PRIORITIES = [
    :PRIORITY_PERSON,
    :PRIORITY_GROUP,
    :PRIORITY_ORGANIZATION,
    :PRIORITY_COMPANY,
    :PRIORITY_DOMAIN,
    :PRIORITY_SENTINEL,
  ].freeze
  PRIORITIES.each_with_index do |sym, n|
    const_set(sym, n)
  end

  def initialize(name, priority, klass_name = nil)
    @name = name
    @priority = priority
    @klass_name = klass_name || @name.to_s.classify
  end

  def after_create(record)
    person = record.person
    return true unless person
    return true unless User.exists? :person_id => person.id
    destory_old_permissions(record)
    roleable_id = record.__send__ "#{@name}_id"
    conditions = { :roleable_id => roleable_id, :roleable_type => @klass_name }
    GrantOn.find_with_period(:all, :conditions => conditions).each do |grant_on|
      Permission.create_with_grant_on_and_user_id_and_priority(grant_on, person.user.id, @priority, record.inception, record.expiry)
    end
  end

  alias after_update after_create

  def after_destroy(record)
    person = record.person
    return true unless person
    return true unless User.exists? :person_id => person.id
    destory_old_permissions(record)
  end

  private

  def destory_old_permissions(record)
    roleable_id = record.__send__ "#{@name}_id_was"
    c = {:roleable_id => roleable_id, :roleable_type => @klass_name}
    GrantOn.find_with_period(:all, :conditions => c).each do |grant_on|
      Permission.find_with_period(:all, :conditions => "grant_on_id = '#{grant_on.id}'").each {|x| x.destroy}
      yield grant_on if block_given?
    end
  end
end
