# 月別詳細一覧画面「勤務形態」表示
class ItemPseudo::PjcWorkingReptWorkOrVacationInput
  include ActionView::Helpers::TagHelper
  include ActionView::Helpers::FormTagHelper
  include ActionView::Helpers::FormHelper
  include ActionView::Helpers::FormOptionsHelper
  include GetText::Rails
  include ERB::Util
  include GetText

  bindtextdomain("database")

  def initialize(item)
  end

  def to_data(it, &block)
    label_work = h(s_("PjcWorkingRept|Options|WORK_OR_VACATION|Work"))
    label_rest = h(s_("PjcWorkingRept|Options|WORK_OR_VACATION|Rest"))

    html = ""
    column_name = "work_or_vacation"
    it.work_or_vacation = it.work_or_vacation.to_s unless it.work_or_vacation.blank?

    [1, 2].each do |value|
      id = "it__#{column_name}_#{value}"
      checked_tag = value.to_s==it.work_or_vacation ? " checked=\"checked\" " : " "
      html << "<input#{checked_tag}id=\"#{id}\" name=\"it[#{column_name}]\" value=\"#{value}\" type=\"radio\" onClick=\"if(#{id}.checked){it_select_reason.disabled=#{value==1?"true":"false"};}\">"
      html << "<label for=\"#{id}\">#{value==1?label_work:label_rest}</label>"
    end

    reasons = []
    #no_select = [ "" , "" ]
    reasons = InputOption.find(:all, :select=>"po_messages.msgid as _msgid, input_options.value as _value", :conditions=>"category='pjc_working_rept_vacation_reason'", :joins=>"INNER JOIN po_messages ON po_messages.id=input_options.name_po").map do |c|
                    [h(s_(c._msgid.to_s)), c._value]
                 end.uniq #.unshift(no_select)

    it.work_or_vacation=="1" ? is_disabled=true : is_disabled=false
    it.vacation_reason.blank? ? selected_reason_id = "" : selected_reason_id = it.vacation_reason

    html << "&nbsp;" * 2
    html << select_tag("it_select_reason", options_for_select(reasons, selected_reason_id), :disabled=>is_disabled, :name=>"it[vacation_reason]")
  end

end
