# 設備予約詳細画面「予約時間」表示
class ItemPseudo::PjcBookingReservationPeriod
  include ActionView::Helpers::DateHelper
  include ERB::Util
  include GetText

  bindtextdomain("database")

  def initialize(item)
    @spacer_tag = "&nbsp;" * 4
  end

  def to_data(it, &block)
    start_datetime = "#{Date.parse(it.reservation_start_day).strftime("%Y/%m/%d")}&nbsp;#{it.reservation_start_time[0,2]}:#{it.reservation_start_time[2,2]}"
    end_datetime = "#{Date.parse(it.reservation_end_day).strftime("%Y/%m/%d")}&nbsp;#{it.reservation_end_time[0,2]}:#{it.reservation_end_time[2,2]}"
    return "#{start_datetime}#{@spacer_tag}～#{@spacer_tag}#{end_datetime}"
  end
end
