# 設備予約詳細画面「設備名称」入力
class ItemPseudo::PjcBookingEquipmentNameInput
  include ActionView::Helpers::DateHelper
  include ActionView::Helpers::TagHelper
  include ActionView::Helpers::FormTagHelper
  include ActionView::Helpers::FormHelper
  include ActionView::Helpers::FormOptionsHelper
  include ERB::Util
  include GetText

  bindtextdomain("database")

  def initialize(item)
  end

  def to_data(it, &block)
    selected_division_id = -1
    selected_equipment_id = -1

    equipments = []
    no_select = [ "" , -1 ]

    division_types = PjcEquipmentDivision.find(:all).map { |c| [c.name, c.id] } #.uniq.unshift(no_select)

    unless it.division_id.blank?
      selected_division_id = it.division_id.to_i
      PjcEquipment.find(:all, :conditions=>[ "equipment_division_id=?", it.division_id]).each do |item|
        if item.writable? then
          equipments << [item.name, item.id]
        end
      end
      #equipments.unshift(no_select)

      unless it.equipment_id.blank?
        selected_equipment_id = it.equipment_id.to_i
      end
    end

    html = "<table id='equipment_name' width='100%' class='pseudo_inbox'><tr>"
    html << "<td width='50%'>#{h(s_("PjcBooking|kind of equipment"))}:&nbsp;#{select_tag( 'division_id', options_for_select(division_types, selected_division_id), :onChange => "this.form.onsubmit(); return false;")}</td>"
    if equipments.size > 0 then
      html << "<td width='50%'>#{h(s_("PjcBooking|equipment_id"))}:&nbsp;#{select_tag( 'equipment_id', options_for_select(equipments, selected_equipment_id) )}</td>"
    else
      html << "<td width='50%'>#{h(s_("PjcBooking|equipment_id"))}:&nbsp;<span class='error_color'>#{h(s_("PjcBooking|There is no registration equipment."))}</span></td>"
    end
    html << "</tr></table>"
  end
end
