# -*- coding: utf-8 -*-
module DisplayNarrowingHelper

  # display_narrowings が仮定される。
  module Handler

    # 絞り込みが有効かどうかを判定する。
    def narrowing?
      !display_narrowings.empty?
    end

    # 絞り込みのコントローラのパスを返す。
    def narrowing_controller_path(value)
      active_display_narrowing(value).controller_path
    end

    # 絞り込みのアクション名を返す。
    def narrowing_action_name(value)
      active_display_narrowing(value).action_name
    end

    # 絞り込むためのオブジェクトの値にアクセスするためのキーの配列を返す。
    def narrowing_value_keys(value=nil)
      if value
        active_display_narrowing(value).value_keys
      else
        display_narrowings.map(&:value_keys).flatten
      end
    end

    # 絞り込むための値を渡して現在の状態を変更する。
    def narrow_to(value)
      active_display_narrowing(value).narrow_to(value)
    end

    # 現在活性になっている絞り込みを返す。
    # value には session を期待している。
    def active_display_narrowing(value)
      v = value[:display_narrowing] && value[:display_narrowing][self.id]
      a = display_narrowings.detect {|x| x.narrowing_id == v[:id]} if v.is_a?(Hash)
      a ||= display_narrowings.first
    end

    private

    # 絞り込みが有効な状態にある場合にはその条件を SQL で構成する。さもなくば nil を返す。
    def narrowing_condition(value)
      active_display_narrowing(value).condition
    end

  end

  # コントローラおよびヘルパー共通で利用される。
  module Common

    def display_narrowing_with(path, action)
      display = Display.find_by_id(params[:display_id])
      return nil unless display
      display_narrowing = display.display_narrowings.detect do |x|
        x.narrowing && x.narrowing.controller_path == path && x.narrowing.action_name == action
      end
      display_narrowing
    end

    def display_narrowing_id_with(path, action)
      display_narrowing = display_narrowing_with(path, action)
      display_narrowing && display_narrowing.id
    end

  end

  # コントローラで利用される。
  module Controller
    include Common

    def display_narrowing_id(path=nil, action="narrow")
      display_narrowing_id_with(path || controller_path, action)
    end

    def destroy_default_narrowings
      narrowings = Narrowing.find(:all, :select => "id", :conditions => {:controller_path => controller_path})
      DefaultNarrowing.destroy_all(:user_id => User.current_id, :narrowing_id => narrowings.map(&:id))
    end

  end

  # ヘルパーで利用される。
  module Helper
    include Common

    def display_narrowing_id(path=nil, action="narrow")
      path ||= @controller.controller_path
      display_narrowing_id_with(path, action)
    end

    def narrowing_text
      @display.active_display_narrowing(session).text(session)
    end

  end

end
