require "active_record"

# 日付を格納するカラムのアクセサを置き換えるモジュール。
module DateColumn
  def date_column(*column_names)
    column_names.each do |column_name|
      column_name = column_name.to_s
      class_eval <<-"end_eval", __FILE__, __LINE__+1
        def #{column_name}
          value = read_attribute(#{column_name.dump})
          return value ? value.to_display_date : value
        end
        def #{column_name}_before_type_cast
          value = read_attribute(#{column_name.dump})
          return value ? value.to_display_date : value
        end
        def #{column_name}=(value)
          value = value.to_db_date if value
          write_attribute(#{column_name.dump}, value)
        end
      end_eval
    end
  end
end
ActiveRecord::Base.send(:extend, DateColumn)
