# 日付フォーマット部品の実装。
module CustomFormatTranslator

  STRFTIME_TABLE = {
    "yyyy"       => "%Y",
    "yy"         => "%y",
    "yyyy/mm"    => "%Y/%m",
    "yyyy-mm"    => "%Y-%m",
    "yyyymm"     => "%Y%m",
    "yy/mm"      => "%y/%m",
    "yy-mm"      => "%y-%m",
    "yymm"       => "%y%m",
    "yyyy/mm/dd" => "%Y/%m/%d",
    "yyyy-mm-dd" => "%Y-%m-%d",
    "yyyymmdd"   => "%Y%m%d",
    "yy/mm/dd"   => "%y/%m/%d",
    "yy-mm-dd"   => "%y-%m-%d",
    "yymmdd"     => "%y%m%d",
  }

  # <em>date</em> を <em>format</em> に従って書式化し文字列として返す。
  def self.format_date(date, format)
    raise ArgumentError, "invalid format: #{format}" unless STRFTIME_TABLE.has_key?(format)
    return date.strftime(STRFTIME_TABLE[format])
  end
end
