if %w|development test|.include?(ENV['RAILS_ENV'])
  module Kernel
    private
    alias dont_open_tmp_original_open open # :nodoc:
    def open(name, *rest, &block) # :nodoc:
      if /\A\/tmp\// =~ name.to_s
        message = "don't open file under /tmp, use RAILS_ROOT/tmp instead: open(*#{[name, *rest].inspect})"
        warn "WARNING: #{message}"
        raise message
      end
      dont_open_tmp_original_open(name, *rest, &block)
    end
    module_function :open
  end

  class << File
    alias dont_open_tmp_original_open open # :nodoc:
    def open(name, *rest, &block) # :nodoc:
      if /\A\/tmp\// =~ name.to_s
        message = "don't open file under /tmp, use RAILS_ROOT/tmp instead: open(*#{[name, *rest].inspect})"
        warn "WARNING: #{message}"
        raise message
      end
      dont_open_tmp_original_open(name, *rest, &block)
    end
  end
end
