# To change this template, choose Tools | Templates
# and open the template in the editor.

module ConfigOutput::PjcWorkingReptMonthDetail
  def output_rows(display_id, options, session_readonly)
    result = []
    #findメソッド実行に必要な情報を全てセットする。
    options[:select] ="month_workinghour_repts.workinghour_report_number,
                       month_workinghour_repts.reporting_person_id,
                       month_workinghour_repts.reporting_month,
                       people.name as reporting_person_name,
                       month_workinghour_repts.break_total_time,
                       month_workinghour_repts.overtime_total_work_time,
                       month_workinghour_repts.night_total_work_time,
                       month_workinghour_repts.total_work_time as month_total_work_time, "
    options[:select] << "day_workinghour_repts.id, reporting_date,
                       work_or_vacation, vacation_reason,
                       date_changed, work_start_time,
                       work_end_time, break_time,
                       overtime_work_time, night_work_time,
                       day_workinghour_repts.total_work_time as day_total_work_time"
    options[:conditions] = options[:conditions] ? "#{options[:conditions]} and 
                       (month_workinghour_repts.id = #{session_readonly[:month_workinghour_rept_id]})" : "(month_workinghour_repts.id =#{session_readonly[:month_workinghour_rept_id]})"
    options[:join] = "INNER JOIN people ON people.id=month_workinghour_repts.reporting_person_id
                      LEFT JOIN day_workinghour_repts ON day_workinghour_repts.month_workinghour_rept_id=month_workinghour_repts.id"
    options[:order] = "reporting_date ASC"

    #項目の並び順を取得してselect句を組み立てる。
    selects =[]
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      selects << output_item.item.column_name
    end
    PjcMonthWorkinghourRept.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      cols = []
      cols << reporting_date(row)
      cols << work_or_vacation(row)
      cols << date_changed(row)
      selects.each do |col|
        if col && row.__send__("#{col}")
          cols << applay_fixed_format(col, row.__send__("#{col}"))
        else
          cols << ""
        end
      end
      result << cols
    end
    return result
  end

  # 定型のフォーマット変換を適用する
  def applay_fixed_format(column_name, data, is_type_number = false)
    case
    when (/_month\z/ =~ column_name)
      data = Date.parse("#{data}01")
      month_name = s_("Date|month|#{data.strftime("%B")}")
      data = s_("Item|Date|%3$s,%1$s") % [data.year, data.month, month_name]

    when (/_day\z/ =~ column_name) , (/_date\z/ =~ column_name)
      begin
        data = Date.parse(data)
        if is_type_number then
          data = data.strftime("%Y/%m/%d")
        else
          month_name = s_("Date|month|#{data.strftime("%B")}")
          data = s_("Item|Date|%4$s %3$s,%1$s") % [data.year, data.month, data.day, month_name]
        end
      rescue
      end

    when ((/_start_time\z/ =~ column_name) or (/_end_time\z/ =~ column_name))

      if (data.index(":") == nil) and /(0[0-9]|1[0-9]|2[0-3])[0-5][0-9]/ =~ data
        data = "#{data[0,2]}:#{data[2,2]}"
      end

    when /_time\z/ =~ column_name
      data = convert_to_hour_minute_from(data)
    end

    return data
  end

  # 分数を（時間数）：（分数）の表記に変換する
  def convert_to_hour_minute_from(minute)
    if minute
      if minute.to_s == (minute.to_i).to_s
        return "#{(minute.to_i/60)}:#{sprintf("%02d",(minute.to_i%60))}"
      else
        return minute
      end
    end
  end

  def reporting_date(it)
    msgstr = ""
    unless it.reporting_date.blank?
      date = Date.parse(it.reporting_date)
      month_name = s_("Date|month|#{date.strftime("%B")}")
      wday = s_("rfw|Calendar|#{date.strftime("%a")}")
      msgstr = "Item|Date|%3$s %4$s %2$s"
      msgstr = s_(msgstr)%[date.month, date.day, wday, month_name]
    end
    return msgstr
  end

  def work_or_vacation(it)
    if it.work_or_vacation=="1" then
      s_("PjcWorkingRept|Options|WORK_OR_VACATION|Work")
    else
      reason = ""
      input_option = InputOption.find(:first, :select=>"name_po", :conditions=>["value=? and category='pjc_working_rept_vacation_reason'", it.vacation_reason])
      if input_option
        po_messeage = PoMessage.find(:first, :select=>"msgid", :conditions=>["id=?", input_option.name_po])
        if po_messeage
          reason ="(#{s_(po_messeage.msgid)})"
        end
      end
      s_("PjcWorkingRept|Options|WORK_OR_VACATION|Rest") + reason
    end
  end

  def date_changed(it)
    it.date_changed ? s_("PjcWorkingRept|Options|DATE_CHANGED|Changed") : s_("PjcWorkingRept|Options|DATE_CHANGED|None")
  end
end
