# To change this template, choose Tools | Templates
# and open the template in the editor.

class PjcProjectLogic < BusinessLogic
  # 既定の事前処理(および事後処理)
  # 何もせず <em>x</em> を返す。
  def postprocess(action, user, x, pool)

    #明細件の存在チェック
#    if pool["detail_count"] == 0 || pool["detail_count"] == nil
#      x.errors.add(:name, "Please input one details or more")
#      pool = nil
#      return nil
#    end

    unless action == :destroy
      #所有権情報の設定
      #プロジェクト登録者に権限付与
      DataIsOccupied.property_right_is_acquired(x,user)
      #プロジェクト責任者に権限付与
      property_right_is_acquired(x,x.person_in_charge_of_project_id)
      #プロジェクトメンバーに権限付与
      PjcProjectMember.find_all_by_project_id(x.id).each do |m|
        property_right_is_acquired(x,m.person_id)
      end
    end

    if action == :create
       #デフォルト業務を追加する。
      pj_segment = PjcProjectSegment.new
      pj_segment.domain_id = x.domain_id
      pj_segment.project_id = x.id
      pj_segment.code = ""
      pj_segment.name = x.name
      pj_segment.save!


      PjInputOption.find_all_by_original(true).each do |original|
        #当該プロジェクトのカテゴリデータを取得
        category = PjcPjInputOptionCategory.find(:first ,
                                                 :conditions => {:project_id => x.id ,
                                                                 :category => original.category} )
        unless category
          #存在しない時
          category = PjcPjInputOptionCategory.new
          category.domain_id = x.domain_id
          category.project_id = x.id
          category.category = original.category
          category.save!
        end
        value = PjcPjInputOptionValue.new
        value.domain_id = x.domain_id
        value.project_id = x.id
        value.input_option_category_id = category.id
        value.value = original.value
        Language.all.each do |lang|
            value.__send__("name#{lang.id}=",original.__send__("name_#{lang.code}"))
        end
        value.save!
        PjInputOption.generate_input_options(original.category,{:project_id => x.id},{:project_id => x.id})
      end
    end
    return x
  end

  private

  def property_right_is_acquired(x,id)
      p = Person.find(:first,:conditions=>{ :id => id})
      if p
        u = User.find(:first,:conditions=>{ :person_id => p.id })
        if u
          DataIsOccupied.property_right_is_acquired(x,u)
        end
      end
  end

end

#class PjcProjectMemberLogic < BusinessLogic
#
#  def afterprocess(action, user, x, pool)
#
#    unless pool["detail_count"]
#      pool["detail_count"] = 0
#    end
#
#    unless action == :destroy
#      pool["detail_count"] = pool["detail_count"] + 1
#      #明細必須項目の重複チェック
#      if pool.has_key?(x.person_id)
#        x.errors.add(:person_id, "The member overlaps")
#        pool = nil
#        return nil
#     else
#        pool[x.person_id] = ""
#      end
#    end
#
#    return x
#  end
#end
