# ビジネスロジックインジェクションのためのクラス。
# 任意のインジェクションのためのクラスは必ずこのクラスを継承する。
#
# インスタンスメソッド
# [<tt>preprocess</tt>] 事前処理
# [<tt>postprocess</tt>] 事後処理
# [<tt>midprocess</tt>] 中間処理
# [<tt>beforeprocess</tt>] 毎事前処理
# [<tt>afterprocess</tt>] 毎事後処理
# をそれぞれの処理として実装する。いずれの場合も引数として
# [<em>action</em>] 実行されるアクション
# [<em>user</em>] 実行ユーザー
# [<em>x</em>] 対象オブジェクト
# の3つをともなって呼ばれる。
class BusinessLogic
  class Failure < StandardError; end
  class RecordInvalid < StandardError; end

  # 既定の事前処理(および事後処理)
  # 何もせず <em>x</em> を返す。
  def preprocess(action, user, x)
    return x
  end

  alias midprocess preprocess
  alias postprocess preprocess
  alias beforeprocess preprocess
  alias afterprocess preprocess
end
