require "action_view"

# image_tag を置き換える。
# image_tag の <tt>src</tt> 属性に指定されているファイルが存在しない場合に、
# 代替として文字列を埋め込む。
module AutoImageTag
  IMAGES = {}
  begin
    require "image_size"
    def self.reload
      IMAGES.clear
      Dir.glob(File.join(RAILS_ROOT, "public/images/*.*")).map do |img|
        info = {}
        open(img, "rb") do |f|
          info[:size] = ImageSize.new(f.read).size.join("x")
        end
        info.delete(:size) if info[:size] == "x"
        IMAGES[File.basename(img)] = info.freeze
      end
    end
  rescue LoadError
    def self.reload
      IMAGES.clear
      info = {}.freeze
      Dir.glob(File.join(RAILS_ROOT, "public/images/*.*")).map do |img|
        IMAGES[File.basename(img)] = info
      end
    end
  end

  reload

  # <tt>image_tag</tt> を置き換える。
  def image_tag(source, options={})
    info = IMAGES[source]
    if info
      super(source, info.dup.update(options))
    else
      h(options[:alt] || File.basename(source))
    end
  end

  # <tt>image_submit_tag</tt> を置き換える。
  def image_submit_tag(source, options={})
    info = IMAGES[source]
    if info
      super(source, info.dup.update(options))
    else
      submit_tag(options[:alt] || File.basename(source))
    end
  end
end

::ActionView::Base.__send__(:include, ::AutoImageTag)
