module ActiveRecord
  module Acts
    module Joint
      def self.included(base)
        base.extend(ClassMethods)
      end

      module ClassMethods
        def joints(ids)
          return [] if ids.blank?
          if ids.is_a?(Integer)
            ids = [ids]
          elsif ids.is_a?(Array)
            ids = ids.map(&:to_i).uniq
          else
            ids = ids.split(',').reject(&:blank?).map(&:to_i).uniq
          end
          find(:all, :conditions => {:id => ids}, :order => "id")
        end
      end
    end
  end
end

ActiveRecord::Base.class_eval do
  include ActiveRecord::Acts::Joint
end
