module ActiveRecord
  module Acts
    # (このモジュールはフレームワークのモデルで常に include される。)
    # 文書で関連づけられたインスタンスのモデルになる。
    module DocumentNode
      def self.included(base)
        base.extend(ClassMethods)

        base.class_eval do
          attr_accessor :product_as_document_node

          class << self
            alias_method_chain :inherited, :document_node
          end
        end
      end

      module ClassMethods
        def inherited_with_document_node(subclass)
          inherited_without_document_node(subclass)
          include InstanceMethods
        end
      end

      module InstanceMethods
        def url_options_as_document_node
          {:product_id => product_as_document_node.id, :id => id}
        end

        def fragment_options_as_document_node
          {:product => product_as_document_node, :document => self}
        end

        def name_as_document_node
          __send__(product_as_document_node.document_name_method)
        end

        def number_as_document_node
          __send__(product_as_document_node.document_number_method)
        end

        def content_as_document_node
          __send__(product_as_document_node.document_content_method)
        end
      end
    end
  end
end

ActiveRecord::Base.class_eval do
  include ActiveRecord::Acts::DocumentNode
end
