# This file is auto-generated from the current state of the database. Instead of editing this file, 
# please use the migrations feature of Active Record to incrementally modify your database, and
# then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your database schema. If you need
# to create the application database on another system, you should be using db:schema:load, not running
# all the migrations from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended to check this file into your version control system.

ActiveRecord::Schema.define(:version => 30080102041750) do

  create_table "access_logs", :force => true do |t|
    t.string   "uuid",          :limit => 36
    t.float    "response_time",               :null => false
    t.integer  "login_id"
    t.datetime "accessed_at",                 :null => false
    t.string   "ip_address",                  :null => false
    t.text     "parameters"
    t.string   "created_at",    :limit => 14
    t.string   "updated_at",    :limit => 14
  end

  create_table "account_items", :force => true do |t|
    t.integer "domain_id",                                          :null => false
    t.string  "code",                 :limit => 30
    t.string  "name",                 :limit => 150,                :null => false
    t.string  "taxation_calculation", :limit => 1
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :default => 0, :null => false
  end

  create_table "application_models", :force => true do |t|
    t.integer "domain_id",                                         :null => false
    t.integer "application_table_id",                              :null => false
    t.string  "name",                                              :null => false
    t.string  "parent_method_name"
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                       :default => 0, :null => false
  end

  create_table "application_tables", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "name",                                      :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "attachment_list_maps", :force => true do |t|
    t.integer "domain_id"
    t.string  "table_name",             :limit => 45
    t.string  "join_tables",            :limit => 45
    t.string  "document_number_column", :limit => 45
    t.string  "narrowing_column",       :limit => 45
    t.string  "subject_column",         :limit => 45
    t.string  "created_at",             :limit => 14
    t.string  "updated_at",             :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version"
  end

  create_table "attachments", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.string  "attachable_type",                              :null => false
    t.integer "attachable_id",                                :null => false
    t.string  "file_type",                                    :null => false
    t.integer "file_id",                                      :null => false
    t.string  "description"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "auto_documents", :force => true do |t|
    t.integer "domain_id",                                         :null => false
    t.integer "relatable_product_id"
    t.integer "target_product_id"
    t.string  "target_id_method"
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                       :default => 0, :null => false
  end

  create_table "belongs_tos", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "application_table_id",                                  :null => false
    t.string  "name",                                                  :null => false
    t.string  "class_name"
    t.string  "forein_key"
    t.boolean "polymorphic",                        :default => false
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                       :default => 0,     :null => false
    t.integer "application_model_id"
  end

  create_table "binary_objects", :force => true do |t|
    t.integer "domain_id",                                                          :null => false
    t.string  "name"
    t.string  "mime_type",                  :default => "application/octet-stream", :null => false
    t.binary  "content"
    t.integer "length"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0,                          :null => false
  end

  create_table "blocks", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "type",                                      :null => false
    t.string  "content"
    t.string  "src"
    t.string  "width"
    t.string  "height"
    t.string  "code"
    t.string  "name"
    t.string  "table_name"
    t.string  "column_name"
    t.string  "helper"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "bookings", :force => true do |t|
    t.integer "domain_id",                                                :null => false
    t.integer "equipment_id"
    t.integer "schedule_id"
    t.integer "person_id"
    t.integer "parent_booking_id"
    t.string  "reservation_start_day"
    t.string  "reservation_start_time"
    t.string  "reservation_end_day"
    t.string  "reservation_end_time"
    t.string  "purpose",                    :limit => 400
    t.string  "equipment_user",             :limit => 400
    t.string  "notes",                      :limit => 400
    t.integer "number_of_people"
    t.boolean "edit_other"
    t.integer "regular_reservation_number"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                              :default => 0, :null => false
  end

  create_table "bulletin_board_permits", :force => true do |t|
    t.integer "domain_id",                                      :null => false
    t.integer "bulletin_board_id"
    t.integer "person_id"
    t.string  "permission",        :limit => 1
    t.string  "inception",         :limit => 8
    t.string  "expiry",            :limit => 8
    t.string  "created_at",        :limit => 14
    t.string  "updated_at",        :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                    :default => 0, :null => false
  end

  create_table "bulletin_boards", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "keyword",      :limit => 150
    t.text    "notes"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "business_card_branches", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "company_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "phonetic"
    t.string  "postcode",     :limit => 10
    t.string  "state",        :limit => 15
    t.string  "city",         :limit => 150
    t.string  "address1",     :limit => 120
    t.string  "address2",     :limit => 120
    t.string  "phone_number", :limit => 20
    t.string  "fax_number",   :limit => 20
    t.string  "url"
    t.text    "remarks"
    t.integer "position"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "business_card_companies", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.string  "code",                  :limit => 30
    t.string  "name",                  :limit => 150
    t.string  "phonetic",              :limit => 150
    t.string  "official_company_name", :limit => 150
    t.string  "postcode",              :limit => 10
    t.string  "state",                 :limit => 15
    t.string  "city",                  :limit => 150
    t.string  "address1",              :limit => 120
    t.string  "address2",              :limit => 120
    t.string  "phone_number",          :limit => 20
    t.string  "fax_number",            :limit => 20
    t.string  "url"
    t.text    "remarks"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
  end

  create_table "business_card_organizations", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "company_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "phonetic",     :limit => 150
    t.text    "remarks"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "business_card_orgs", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "company_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "phonetic",     :limit => 150
    t.text    "remarks"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "business_cards", :force => true do |t|
    t.integer "domain_id",                                              :null => false
    t.integer "company_id"
    t.integer "company_branch_id"
    t.integer "organization_id1"
    t.integer "organization_id2"
    t.string  "post_name1",               :limit => 150
    t.string  "post_name2",               :limit => 150
    t.string  "code",                     :limit => 30
    t.string  "name",                     :limit => 150
    t.string  "honorific_title",          :limit => 150
    t.string  "phonetic",                 :limit => 150
    t.string  "name_english_description", :limit => 150
    t.string  "phone_number",             :limit => 20
    t.string  "mobile_phone_number1",     :limit => 20
    t.string  "mobile_phone_number2",     :limit => 20
    t.string  "mail_address1",            :limit => 128
    t.string  "mail_address2",            :limit => 128
    t.string  "postcode",                 :limit => 10
    t.string  "state",                    :limit => 15
    t.string  "city",                     :limit => 150
    t.string  "address1",                 :limit => 120
    t.string  "address2",                 :limit => 120
    t.string  "main_phone_number",        :limit => 20
    t.string  "fax_number",               :limit => 20
    t.string  "url"
    t.text    "remarks"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                            :default => 0, :null => false
  end

  create_table "carfare_details", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.integer "carfare_id"
    t.string  "carfare_use_day",       :limit => 8
    t.integer "project_id"
    t.string  "destination",           :limit => 150
    t.string  "purpose",               :limit => 150
    t.string  "departure",             :limit => 150
    t.string  "arrival",               :limit => 150
    t.integer "fare"
    t.string  "one_way_or_round_trip", :limit => 1
    t.integer "total_amount"
    t.integer "exclude_tax_amount"
    t.integer "tax"
    t.boolean "receipt"
    t.integer "position"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
  end

  create_table "carfares", :force => true do |t|
    t.integer "domain_id",                                          :null => false
    t.string  "carfare_number",        :limit => 30
    t.string  "account_item_division"
    t.integer "account_item_id"
    t.integer "applicant_id"
    t.string  "claimed_month",         :limit => 6
    t.integer "total_amount"
    t.string  "payment_day",           :limit => 8
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :default => 0, :null => false
  end

  create_table "cells", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "pane_id",                                   :null => false
    t.string  "height"
    t.integer "position"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "checklist_tasks", :force => true do |t|
    t.integer "domain_id",                                              :null => false
    t.integer "checklist_id"
    t.integer "parent_checklist_task_id"
    t.string  "code",                     :limit => 30
    t.string  "name",                     :limit => 150
    t.text    "explanation"
    t.boolean "judgment"
    t.integer "position"
    t.integer "task_level"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                            :default => 0, :null => false
  end

  create_table "checklists", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.text    "explanation"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "circular_approvers", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "circular_id"
    t.integer "person_id"
    t.string  "approve_status", :limit => 1
    t.string  "approval_day",   :limit => 8
    t.string  "notes",          :limit => 300
    t.string  "created_at",     :limit => 14
    t.string  "updated_at",     :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "circulars", :force => true do |t|
    t.integer "domain_id",                                                :null => false
    t.string  "circular_number",            :limit => 30
    t.string  "subject",                    :limit => 300
    t.text    "content"
    t.integer "person_of_creation"
    t.integer "person_of_circulation"
    t.integer "end_user_of_confirmation"
    t.string  "circular_start_day",         :limit => 8
    t.string  "circular_end_day",           :limit => 8
    t.string  "end_show_day",               :limit => 8
    t.string  "circulation_open_division",  :limit => 1
    t.boolean "edit_circulater"
    t.boolean "edit_approval"
    t.boolean "send_mail"
    t.boolean "send_mail_with_content"
    t.boolean "send_mail_with_file"
    t.boolean "return_mail_by_approval"
    t.string  "status",                     :limit => 1
    t.string  "confirmation_day",           :limit => 8
    t.string  "approval_day",               :limit => 8
    t.boolean "delete_by_circulater"
    t.boolean "delete_by_last_confirmater"
    t.boolean "delete_by_creater"
    t.string  "issued_day",                 :limit => 8
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                              :default => 0, :null => false
  end

  create_table "companies", :force => true do |t|
    t.integer "domain_id",                                                 :null => false
    t.string  "code",                        :limit => 30
    t.string  "name",                        :limit => 150
    t.string  "phonetic",                    :limit => 150
    t.string  "official_company_name",       :limit => 150
    t.string  "company_abbreviation_name",   :limit => 150
    t.string  "customer_connection",         :limit => 10
    t.string  "industry",                    :limit => 10
    t.string  "relationship_to_our_company", :limit => 10
    t.string  "phone_number",                :limit => 20
    t.string  "fax_number",                  :limit => 20
    t.string  "mail_address",                :limit => 128
    t.string  "url"
    t.string  "base_postcode",               :limit => 10
    t.string  "base_state",                  :limit => 15
    t.string  "base_city",                   :limit => 150
    t.text    "base_address1"
    t.text    "base_address2"
    t.string  "bill_postcode",               :limit => 10
    t.string  "bill_state",                  :limit => 15
    t.string  "bill_city",                   :limit => 150
    t.text    "bill_address1"
    t.text    "bill_address2"
    t.string  "representative_name",         :limit => 150
    t.string  "person_in_charge_name",       :limit => 150
    t.string  "e_mail_of_person_in_charge",  :limit => 128
    t.string  "capital_funds",               :limit => 15
    t.string  "establishment_date",          :limit => 8
    t.string  "number_of_employees",         :limit => 30
    t.string  "annual_sale_volume",          :limit => 30
    t.text    "remarks"
    t.string  "created_at",                  :limit => 14
    t.string  "updated_at",                  :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "company_members", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "company_id"
    t.integer "person_id"
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "config_attachments", :force => true do |t|
    t.integer "domain_id",                                      :null => false
    t.string  "default_file_type",                              :null => false
    t.integer "maximum_length",                                 :null => false
    t.string  "created_at",        :limit => 14
    t.string  "updated_at",        :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                    :default => 0, :null => false
  end

  create_table "config_output_items", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.integer "config_output_id",                              :null => false
    t.integer "item_id",                                       :null => false
    t.boolean "enabled"
    t.string  "name"
    t.integer "position"
    t.string  "created_at",       :limit => 14
    t.string  "updated_at",       :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "config_outputs", :force => true do |t|
    t.integer "domain_id",                                              :null => false
    t.integer "user_id",                                                :null => false
    t.integer "display_to_list_id",                                     :null => false
    t.string  "file_format",                       :default => "csv",   :null => false
    t.string  "name"
    t.string  "eol_pattern",                       :default => "none",  :null => false
    t.string  "eol_parameter"
    t.string  "separator_pattern",                 :default => "tab",   :null => false
    t.string  "separator_parameter"
    t.string  "quotation_pattern",                 :default => "none",  :null => false
    t.string  "quotation_parameter"
    t.string  "encoding",                          :default => "utf-8", :null => false
    t.string  "created_at",          :limit => 14
    t.string  "updated_at",          :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0,       :null => false
  end

  create_table "config_passwords", :force => true do |t|
    t.integer "domain_id",                                      :null => false
    t.integer "min_length"
    t.boolean "enable_max_age",                                 :null => false
    t.integer "max_age"
    t.boolean "enable_min_age",                                 :null => false
    t.integer "min_age"
    t.boolean "enforce_change"
    t.boolean "enable_lockout",                                 :null => false
    t.integer "lockout_threshold"
    t.string  "created_at",        :limit => 14
    t.string  "updated_at",        :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                    :default => 0, :null => false
  end

  create_table "counters", :force => true do |t|
    t.integer "domain_id",                                   :null => false
    t.string  "table_name",                                  :null => false
    t.integer "current_number",               :default => 0, :null => false
    t.string  "created_at",     :limit => 14
    t.string  "updated_at",     :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                 :default => 0, :null => false
  end

  create_table "day_workinghour_details", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "day_workinghour_rept_id"
    t.integer "project_id"
    t.integer "segment_id"
    t.integer "position"
    t.string  "task_name"
    t.string  "task_start_time",          :limit => 4
    t.string  "task_end_time",            :limit => 4
    t.integer "task_operating_time"
    t.integer "task_progress_rate"
    t.integer "task_record_id"
    t.integer "personal_regular_task_id"
    t.integer "regular_task_id"
    t.text    "notes"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "day_workinghour_repts", :force => true do |t|
    t.integer "domain_id",                                              :null => false
    t.integer "month_workinghour_rept_id"
    t.string  "reporting_date"
    t.string  "work_or_vacation",          :limit => 1
    t.string  "vacation_reason"
    t.boolean "date_changed"
    t.string  "work_start_time",           :limit => 4
    t.string  "work_end_time",             :limit => 4
    t.integer "break_time"
    t.integer "overtime_work_time"
    t.integer "night_work_time"
    t.integer "total_work_time"
    t.text    "notes"
    t.string  "created_at",                :limit => 14
    t.string  "updated_at",                :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                            :default => 0, :null => false
  end

  create_table "default_lists", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "user_id",                                   :null => false
    t.integer "product_id",                                :null => false
    t.integer "display_id",                                :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "default_matters", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "user_id",                                   :null => false
    t.integer "matter_id",                                 :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "default_narrowings", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "user_id",                                      :null => false
    t.integer "narrowing_id",                                 :null => false
    t.text    "narrowing_value"
    t.text    "narrowing_text"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "design_tickets", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "user_id",                                   :null => false
    t.string  "token",                                     :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "display_narrowings", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "narrowing_id",                              :null => false
    t.integer "display_id",                                :null => false
    t.string  "column_name",  :limit => 50,                :null => false
    t.integer "position",                                  :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "displays", :force => true do |t|
    t.integer "domain_id",                                          :null => false
    t.integer "product_id",                                         :null => false
    t.string  "type",                                               :null => false
    t.integer "name_po",                                            :null => false
    t.string  "code",                                               :null => false
    t.integer "position"
    t.boolean "enabled"
    t.boolean "button_new"
    t.boolean "button_edit"
    t.boolean "button_delete"
    t.boolean "button_copy"
    t.string  "logic_path"
    t.boolean "logic_pre"
    t.boolean "logic_mid"
    t.boolean "logic_post"
    t.boolean "logic_before"
    t.boolean "logic_after"
    t.integer "person_id"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :default => 0, :null => false
    t.string  "narrowing_model_name"
    t.string  "narrowing_column_name"
  end

  create_table "document_edges", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "from_id",                                      :null => false
    t.string  "from_type",                                    :null => false
    t.integer "from_product_id",                              :null => false
    t.integer "to_id",                                        :null => false
    t.string  "to_type",                                      :null => false
    t.integer "to_product_id",                                :null => false
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "document_paths", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.integer "document_id",                                   :null => false
    t.integer "document_edge_id",                              :null => false
    t.string  "created_at",       :limit => 14
    t.string  "updated_at",       :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "documents", :force => true do |t|
    t.integer "domain_id",                                         :null => false
    t.integer "relatable_id"
    t.string  "relatable_type"
    t.integer "relatable_product_id"
    t.integer "target_id"
    t.string  "target_type"
    t.integer "target_product_id"
    t.boolean "mutual"
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                       :default => 0, :null => false
  end

  create_table "domains", :force => true do |t|
    t.string  "code",                                      :null => false
    t.string  "name",                                      :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "equipment_classifications", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "code"
    t.string  "name"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "equipment_divisions", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "equipment_permissions", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "equipment_id"
    t.integer "person_id"
    t.string  "permission"
    t.string  "inception"
    t.string  "expiry"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "equipment_permits", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "equipment_id"
    t.integer "person_id"
    t.string  "permission",   :limit => 1
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "equipments", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.integer "equipment_division_id"
    t.string  "code",                  :limit => 30
    t.string  "name",                  :limit => 150
    t.text    "notes"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
  end

  create_table "example_issues", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "example_work_id"
    t.string  "title"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "example_projects", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "name"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "example_quality_assurances", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "example_work_id"
    t.string  "title"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "example_works", :force => true do |t|
    t.integer "domain_id",                                       :null => false
    t.integer "example_project_id"
    t.string  "name"
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                     :default => 0, :null => false
  end

  create_table "framework_tasks", :force => true do |t|
    t.integer "domain_id",                                              :null => false
    t.integer "framework_id"
    t.integer "parent_framework_task_id"
    t.string  "code",                     :limit => 30
    t.string  "name",                     :limit => 150
    t.text    "explanation"
    t.integer "position"
    t.integer "task_level"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                            :default => 0, :null => false
  end

  create_table "frameworks", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.text    "explanation"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "grant_data_informations", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "target_product_id",                                     :null => false
    t.integer "target_display_id",                                     :null => false
    t.float   "layout"
    t.integer "generated_product_id"
    t.integer "generated_item_pseudo_id"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "grant_ons", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.string  "value",                                               :null => false
    t.string  "inception",              :limit => 8,                 :null => false
    t.string  "expiry",                 :limit => 8,                 :null => false
    t.string  "created_at",             :limit => 14
    t.string  "updated_at",             :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
    t.integer "grant_targettable_id"
    t.string  "grant_targettable_type"
    t.integer "roleable_id"
    t.string  "roleable_type"
    t.integer "position"
  end

  create_table "group_members", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "group_id"
    t.integer "person_id"
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
    t.integer "position"
  end

  create_table "groups", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.text    "remarks"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "has_manies", :force => true do |t|
    t.integer "domain_id",                                         :null => false
    t.integer "application_model_id",                              :null => false
    t.string  "name",                                              :null => false
    t.string  "class_name"
    t.string  "foreign_key"
    t.string  "as_name"
    t.string  "dependent"
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                       :default => 0, :null => false
  end

  create_table "holidays", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "year"
    t.integer "month"
    t.integer "day"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
    t.string  "ymd",          :limit => 8
  end

  create_table "input_option_categories", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "category",     :limit => 30
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "input_option_values", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "input_option_category_id"
    t.string  "name1",                    :limit => 30
    t.string  "name2",                    :limit => 30
    t.string  "name3",                    :limit => 30
    t.string  "name4",                    :limit => 30
    t.string  "name5",                    :limit => 30
    t.string  "name6",                    :limit => 30
    t.string  "name7",                    :limit => 30
    t.string  "name8",                    :limit => 30
    t.string  "name9",                    :limit => 30
    t.string  "name10",                   :limit => 30
    t.string  "value",                    :limit => 10
    t.integer "position"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "input_options", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "category"
    t.integer "name_po"
    t.string  "value"
    t.integer "position"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "items", :force => true do |t|
    t.integer "domain_id",                                                         :null => false
    t.integer "display_id",                                                        :null => false
    t.string  "code",                           :limit => 30,                      :null => false
    t.integer "name_po",                                                           :null => false
    t.string  "type",                           :limit => 50,                      :null => false
    t.string  "model_name",                     :limit => 50
    t.string  "column_name",                    :limit => 50
    t.string  "adapter_name"
    t.integer "layout"
    t.string  "width",                          :limit => 10
    t.string  "align",                          :limit => 10,  :default => "left", :null => false
    t.string  "decorator",                      :limit => 20,  :default => "none", :null => false
    t.string  "decorator_parameter",            :limit => 50
    t.boolean "linked",                                        :default => false,  :null => false
    t.string  "link_parameter"
    t.integer "position"
    t.string  "direction",                      :limit => 30
    t.string  "condition_value",                :limit => 100
    t.string  "condition_pattern",              :limit => 100, :default => "none", :null => false
    t.boolean "selected"
    t.boolean "ordered"
    t.boolean "search",                                        :default => true,   :null => false
    t.string  "control",                        :limit => 10,  :default => "free", :null => false
    t.text    "input_type"
    t.string  "field_size",                     :limit => 10
    t.text    "input_parameter"
    t.text    "input_initializer"
    t.text    "input_initial_value"
    t.boolean "validates_presence"
    t.boolean "validates_non_negative_integer"
    t.boolean "validates_integer"
    t.boolean "validates_non_negative_float"
    t.boolean "validates_float"
    t.boolean "validates_zero"
    t.boolean "validates_upper_case"
    t.boolean "validates_lower_case"
    t.boolean "validates_alphabetic"
    t.boolean "validates_alphanumeric"
    t.boolean "validates_halfwidth_katakana"
    t.boolean "validates_fullwidth"
    t.boolean "validates_fullwidth_katakana"
    t.boolean "validates_inclusion_chars"
    t.boolean "validates_minimum_length"
    t.boolean "validates_maximum_length"
    t.boolean "validates_integral_length"
    t.boolean "validates_fractional_length"
    t.boolean "validates_year"
    t.boolean "validates_year_month"
    t.boolean "validates_year_month_day"
    t.boolean "validates_hour"
    t.boolean "validates_hour_minute"
    t.boolean "validates_postal_code"
    t.boolean "validates_phone_number"
    t.boolean "validates_email"
    t.boolean "validates_url"
    t.boolean "validates_minimum_number"
    t.boolean "validates_period"
    t.boolean "validates_future_date"
    t.boolean "validates_past_date"
    t.boolean "validates_uniqueness"
    t.boolean "validates_row"
    t.string  "validates_inclusion_chars_1",    :limit => 30
    t.string  "validates_minimum_length_1",     :limit => 10
    t.string  "validates_maximum_length_1",     :limit => 10
    t.string  "validates_integral_length_1",    :limit => 10
    t.string  "validates_integral_length_2",    :limit => 10
    t.string  "validates_fractional_length_1",  :limit => 10
    t.string  "validates_fractional_length_2",  :limit => 10
    t.string  "validates_minimum_number_1",     :limit => 10
    t.string  "validates_period_1",             :limit => 100
    t.string  "validates_period_2",             :limit => 100
    t.string  "validates_row_1",                :limit => 100
    t.string  "validates_row_2",                :limit => 100
    t.string  "created_at",                     :limit => 14
    t.string  "updated_at",                     :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                  :default => 0,      :null => false
    t.text    "method_chain"
    t.boolean "validates_isolated"
    t.string  "validates_isolated_1",           :limit => 100
    t.integer "write_protected",                :limit => 1
  end

  add_index "items", ["domain_id", "display_id", "layout"], :name => "idx_items"

  create_table "languages", :force => true do |t|
    t.string  "code",         :limit => 2,                 :null => false
    t.integer "name_po",                                   :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "layers", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.integer "cell_id",                                       :null => false
    t.integer "containable_id",                                :null => false
    t.string  "containable_type",                              :null => false
    t.string  "created_at",       :limit => 14
    t.string  "updated_at",       :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "lend_expense_details", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.integer "lend_expense_id"
    t.string  "lend_expense_use_day",  :limit => 8
    t.integer "project_id"
    t.string  "purpose",               :limit => 300
    t.string  "account_item_division"
    t.integer "account_item_id"
    t.integer "amount"
    t.integer "exclude_tax_amount"
    t.integer "tax"
    t.boolean "receipt"
    t.integer "position"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
  end

  create_table "lend_expenses", :force => true do |t|
    t.integer "domain_id",                                        :null => false
    t.string  "lend_expense_number", :limit => 30
    t.integer "total_amount"
    t.string  "payment_day",         :limit => 8
    t.integer "applicant_id"
    t.string  "created_at",          :limit => 14
    t.string  "updated_at",          :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0, :null => false
  end

  create_table "login_histories", :force => true do |t|
    t.integer "domain_id"
    t.string  "login"
    t.string  "password"
    t.integer "result",                                      :null => false
    t.string  "remote_address"
    t.integer "program_type",                                :null => false
    t.integer "user_id"
    t.string  "created_at",     :limit => 14
    t.string  "updated_at",     :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                 :default => 0, :null => false
  end

  create_table "mail_formats", :force => true do |t|
    t.integer "domain_id",                                      :null => false
    t.string  "mail_mode"
    t.string  "from_format"
    t.string  "recipients_format"
    t.string  "subject_format"
    t.text    "body_format"
    t.string  "created_at",        :limit => 14
    t.string  "updated_at",        :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                    :default => 0, :null => false
  end

  create_table "mail_histories", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "mail_queue_id",                                :null => false
    t.string  "from_value",                                   :null => false
    t.string  "recipient_value",                              :null => false
    t.string  "subject",                                      :null => false
    t.text    "body",                                         :null => false
    t.string  "status",                                       :null => false
    t.text    "error_log"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "mail_queues", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "product_id",                                   :null => false
    t.integer "document_id",                                  :null => false
    t.string  "document_type",                                :null => false
    t.integer "from_id",                                      :null => false
    t.string  "recipient_ids",                                :null => false
    t.text    "comment_message"
    t.string  "field_type",                                   :null => false
    t.boolean "has_attachment",                               :null => false
    t.string  "auto_login_url",                               :null => false
    t.string  "mail_mode",                                    :null => false
    t.boolean "copy_to_sender",                               :null => false
    t.boolean "processed",                                    :null => false
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "matter_negotiations", :force => true do |t|
    t.integer "domain_id",                                                :null => false
    t.integer "matter_id"
    t.string  "matter_negotiation_number",  :limit => 30
    t.string  "subject",                    :limit => 300
    t.string  "place",                      :limit => 300
    t.string  "date_of_negotiation",        :limit => 8
    t.string  "start_time",                 :limit => 5
    t.string  "end_time",                   :limit => 5
    t.string  "means"
    t.integer "person_in_charge_of_opp_id"
    t.text    "remarks_of_opp"
    t.integer "person_in_charge_id"
    t.text    "remarks_of_our_company"
    t.text    "content_of_negotiation"
    t.string  "subject_of_ns",              :limit => 300
    t.string  "place_of_ns",                :limit => 300
    t.string  "date_of_negotiation_of_ns",  :limit => 8
    t.string  "start_time_of_ns",           :limit => 5
    t.string  "end_time_of_ns",             :limit => 5
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                              :default => 0, :null => false
  end

  create_table "matter_problems", :force => true do |t|
    t.integer "domain_id",                                                 :null => false
    t.integer "matter_id"
    t.string  "matter_problem_number",       :limit => 30
    t.string  "subject",                     :limit => 300
    t.integer "person_of_issued_id"
    t.integer "person_in_charge_of_work_id"
    t.string  "category"
    t.string  "priority_level"
    t.string  "process"
    t.string  "process_of_solution"
    t.text    "content_of_problem"
    t.text    "content_of_solution"
    t.string  "plan_of_start_date",          :limit => 8
    t.string  "plan_of_end_date",            :limit => 8
    t.string  "start_date",                  :limit => 8
    t.string  "end_date",                    :limit => 8
    t.string  "situation_of_work"
    t.text    "notes"
    t.string  "created_at",                  :limit => 14
    t.string  "updated_at",                  :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "matter_questions", :force => true do |t|
    t.integer "domain_id",                                            :null => false
    t.integer "matter_id"
    t.string  "matter_question_number", :limit => 30
    t.string  "subject",                :limit => 300
    t.integer "person_of_issued_id"
    t.integer "expected_respondent_id"
    t.string  "category"
    t.string  "priority_level"
    t.string  "process"
    t.string  "process_of_solution"
    t.text    "question"
    t.text    "answer"
    t.string  "expected_answer_date",   :limit => 8
    t.string  "answer_date",            :limit => 8
    t.string  "situation_of_work"
    t.text    "notes"
    t.string  "created_at",             :limit => 14
    t.string  "updated_at",             :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0, :null => false
  end

  create_table "matter_reports", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.string  "code"
    t.string  "name",                                          :null => false
    t.string  "category"
    t.integer "order_company_id"
    t.integer "order_person_id"
    t.string  "delivery_date"
    t.string  "receipt_date"
    t.integer "sales_person_id"
    t.string  "description"
    t.integer "estimate_amount"
    t.integer "final_amount"
    t.string  "possibility"
    t.string  "status"
    t.string  "created_at",       :limit => 14
    t.string  "updated_at",       :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "matters", :force => true do |t|
    t.integer "domain_id",                                                   :null => false
    t.string  "code",                          :limit => 30
    t.string  "name",                          :limit => 150
    t.string  "matter_division"
    t.string  "matter_start_date",             :limit => 8
    t.integer "client_company_id"
    t.integer "person_in_charge_of_client_id"
    t.integer "delivery_destination_id"
    t.string  "delivery_date",                 :limit => 8
    t.integer "person_in_charge_of_sales_id"
    t.string  "matter_sum_amount",             :limit => 12
    t.string  "expected_order_amount",         :limit => 12
    t.string  "order_amount",                  :limit => 12
    t.string  "order_precision"
    t.string  "order_stage"
    t.string  "order_plan_month",              :limit => 6
    t.string  "order_month",                   :limit => 6
    t.string  "sales_plan_month",              :limit => 6
    t.string  "sales_month",                   :limit => 6
    t.text    "matter_content"
    t.text    "notes"
    t.integer "retrieval_division_id1"
    t.integer "retrieval_division_id2"
    t.integer "retrieval_division_id3"
    t.integer "retrieval_division_id4"
    t.integer "retrieval_division_id5"
    t.integer "retrieval_division_id6"
    t.integer "retrieval_division_id7"
    t.integer "retrieval_division_id8"
    t.integer "retrieval_division_id9"
    t.integer "retrieval_division_id10"
    t.string  "created_at",                    :limit => 14
    t.string  "updated_at",                    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                 :default => 0, :null => false
  end

  create_table "memorandums", :force => true do |t|
    t.integer "domain_id",                          :null => false
    t.integer "addressee_person_id",                :null => false
    t.integer "sender_person_id",                   :null => false
    t.string  "other_person_name",   :limit => 45,  :null => false
    t.string  "memo",                :limit => 225, :null => false
    t.boolean "read_status"
    t.string  "created_at",          :limit => 14
    t.string  "updated_at",          :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                       :null => false
  end

  create_table "menus", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "code",                                      :null => false
    t.integer "name_po",                                   :null => false
    t.string  "motion"
    t.integer "parent_id"
    t.integer "lft"
    t.integer "rgt"
    t.integer "product_id"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  add_index "menus", ["domain_id", "parent_id"], :name => "idx_menus"

  create_table "month_workinghour_repts", :force => true do |t|
    t.integer "domain_id",                                              :null => false
    t.string  "workinghour_report_number", :limit => 30
    t.integer "reporting_person_id"
    t.string  "reporting_month",           :limit => 6
    t.integer "break_total_time"
    t.integer "overtime_total_work_time"
    t.integer "night_total_work_time"
    t.integer "total_work_time"
    t.string  "created_at",                :limit => 14
    t.string  "updated_at",                :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                            :default => 0, :null => false
  end

  create_table "multiapplication_forms", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.string  "multiapplication_number", :limit => 30
    t.string  "subject",                 :limit => 150
    t.text    "notes"
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "multipurpose_apply_forms", :force => true do |t|
    t.integer "domain_id",                                       :null => false
    t.string  "apply_forms_number"
    t.text    "notes"
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                     :default => 0, :null => false
  end

  create_table "narrowings", :force => true do |t|
    t.integer "domain_id",                                                   :null => false
    t.string  "type",                    :limit => 20,                       :null => false
    t.string  "controller_path",                                             :null => false
    t.string  "action_name",             :limit => 50, :default => "narrow"
    t.string  "model_name",              :limit => 50
    t.string  "condition_template_name", :limit => 32
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0,        :null => false
  end

  create_table "news", :force => true do |t|
    t.integer "domain_id",                                       :null => false
    t.integer "bulletin_board_id"
    t.integer "publish_person_id"
    t.string  "news_number"
    t.string  "publish_start_day"
    t.string  "publish_start_time"
    t.string  "publish_end_day"
    t.string  "subject"
    t.string  "related_url"
    t.text    "content"
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                     :default => 0, :null => false
    t.integer "publish_day_count"
  end

  create_table "news_readers", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "news_id"
    t.integer "person_id"
    t.boolean "readed_status"
    t.string  "created_at",    :limit => 14
    t.string  "updated_at",    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "notifications", :force => true do |t|
    t.integer "domain_id",                  :null => false
    t.integer "schedule_id",                :null => false
    t.integer "person_id",                  :null => false
    t.string  "person_type",  :limit => 1,  :null => false
    t.boolean "invisible"
    t.boolean "canceled"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :null => false
  end

  create_table "organization_members", :force => true do |t|
    t.integer "domain_id",                                    :null => false
    t.integer "organization_id"
    t.integer "person_id"
    t.string  "inception",       :limit => 8
    t.string  "expiry",          :limit => 8
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "organizations", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "company_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "phonetic"
    t.text    "remarks"
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "panes", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "screen_id",                                 :null => false
    t.string  "width"
    t.integer "position"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "payments", :force => true do |t|
    t.integer "domain_id",                                                 :null => false
    t.string  "payment_number",              :limit => 30
    t.string  "account_item_division"
    t.integer "account_item_id"
    t.integer "applicant_id"
    t.string  "payee_name",                  :limit => 150
    t.integer "payee_company_id"
    t.integer "payee_person_id"
    t.integer "amount"
    t.integer "exclude_tax_amount"
    t.integer "tax"
    t.string  "claimed_day",                 :limit => 8
    t.string  "pay_time_limit",              :limit => 8
    t.integer "project_id"
    t.string  "contents",                    :limit => 300
    t.boolean "used_by_corporate_card"
    t.string  "transfer_bank",               :limit => 150
    t.string  "transfer_bank_branch_office", :limit => 150
    t.string  "account_kind"
    t.string  "account_number",              :limit => 10
    t.string  "account_name",                :limit => 150
    t.text    "transfer_remarks"
    t.boolean "have_written_order"
    t.string  "order_day",                   :limit => 8
    t.string  "order_number",                :limit => 30
    t.text    "terms_of_payment"
    t.text    "order_remarks"
    t.text    "other_remarks"
    t.string  "pay_day",                     :limit => 8
    t.string  "created_at",                  :limit => 14
    t.string  "updated_at",                  :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "people", :force => true do |t|
    t.integer "domain_id",                                                    :null => false
    t.string  "code",                           :limit => 30
    t.string  "name",                           :limit => 150
    t.string  "phonetic",                       :limit => 150
    t.string  "honorific_title",                :limit => 150
    t.string  "personal_division",              :limit => 1
    t.text    "mail_address"
    t.string  "last_language",                  :limit => 2
    t.integer "default_company_id"
    t.integer "default_organization_id"
    t.integer "default_post_id"
    t.boolean "receive_mail"
    t.string  "join_company_date",              :limit => 8
    t.text    "work_place"
    t.string  "sex",                            :limit => 1
    t.string  "birthday",                       :limit => 8
    t.string  "age",                            :limit => 3
    t.string  "phone_number",                   :limit => 20
    t.string  "fax_number",                     :limit => 20
    t.string  "exterior_line_number",           :limit => 10
    t.string  "interior_line_number",           :limit => 10
    t.string  "phs",                            :limit => 20
    t.string  "mobile_phone_number",            :limit => 20
    t.string  "mobile_phone_mail_send",         :limit => 1
    t.string  "mobile_phone_career",            :limit => 1
    t.string  "mobile_phone_mail",              :limit => 128
    t.text    "personal_homepage"
    t.text    "mail_address1"
    t.text    "mail_address2"
    t.string  "priv_mobile_phone_number",       :limit => 20
    t.string  "priv_phs",                       :limit => 20
    t.string  "priv_home_postcode",             :limit => 10
    t.string  "priv_home_state",                :limit => 15
    t.text    "priv_home_city"
    t.string  "priv_home_address1",             :limit => 120
    t.string  "priv_home_address2",             :limit => 120
    t.string  "priv_home_phone_number",         :limit => 20
    t.string  "priv_home_fax_number",           :limit => 20
    t.text    "priv_home_nearest_trafic_line1"
    t.text    "priv_home_nearest_trafic_line2"
    t.string  "priv_ec_postcode",               :limit => 10
    t.string  "priv_ec_state",                  :limit => 15
    t.text    "priv_ec_city"
    t.string  "priv_ec_address1",               :limit => 120
    t.string  "priv_ec_address2",               :limit => 120
    t.string  "priv_ec_phone_number",           :limit => 20
    t.string  "priv_ec_fax_number",             :limit => 20
    t.text    "priv_ec_name"
    t.text    "priv_ec_name_phonetic"
    t.text    "relationship_to_priv_ec"
    t.integer "new_year_card"
    t.integer "summer_benediction"
    t.integer "year_mid"
    t.integer "year_end"
    t.integer "others1"
    t.integer "others2"
    t.text    "remarks"
    t.string  "created_at",                     :limit => 14
    t.string  "updated_at",                     :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                  :default => 0, :null => false
  end

  create_table "people_old", :force => true do |t|
    t.integer "domain_id",                                               :null => false
    t.string  "name",                                                    :null => false
    t.string  "mail_address"
    t.string  "last_language"
    t.integer "default_company_id"
    t.integer "default_organization_id"
    t.integer "default_post_id"
    t.boolean "receive_mail",                          :default => true
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0,    :null => false
    t.string  "code"
    t.string  "phonetic"
  end

  create_table "permissions", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.integer "grant_on_id",                                         :null => false
    t.integer "user_id",                                             :null => false
    t.integer "priority",                                            :null => false
    t.string  "value",                                               :null => false
    t.string  "inception",              :limit => 8,                 :null => false
    t.string  "expiry",                 :limit => 8,                 :null => false
    t.string  "created_at",             :limit => 14
    t.string  "updated_at",             :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
    t.integer "grant_targettable_id"
    t.string  "grant_targettable_type"
  end

  add_index "permissions", ["user_id"], :name => "index_permissions_on_user_id"

  create_table "personal_booking_sets", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "person_id",                                             :null => false
    t.integer "def_equipment_class_day"
    t.integer "def_equipment_class_week"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "personal_default_tasks", :force => true do |t|
    t.integer "domain_id",                   :null => false
    t.integer "person_id",                   :null => false
    t.integer "regular_id",                  :null => false
    t.string  "regular_type", :limit => 150, :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :null => false
  end

  create_table "personal_destinations", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.integer "person_id"
    t.string  "code",                  :limit => 30
    t.string  "name",                  :limit => 150
    t.string  "departure",             :limit => 150
    t.string  "arrival",               :limit => 150
    t.integer "fare"
    t.string  "one_way_or_round_trip"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
  end

  create_table "personal_group_members", :force => true do |t|
    t.integer "domain_id",                                      :null => false
    t.integer "personal_group_id"
    t.integer "person_id"
    t.string  "inception",         :limit => 8
    t.string  "expiry",            :limit => 8
    t.string  "created_at",        :limit => 14
    t.string  "updated_at",        :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                    :default => 0, :null => false
    t.integer "position"
  end

  create_table "personal_groups", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "person_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.text    "remarks"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "personal_regular_tasks", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "person_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.text    "context"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "personal_schedule_sets", :force => true do |t|
    t.integer "domain_id",                                                 :null => false
    t.integer "person_id"
    t.string  "default_start_time",           :limit => 2
    t.string  "default_start_week",           :limit => 1
    t.boolean "permission_duplication"
    t.integer "def_group_of_gschedule_id"
    t.string  "def_group_of_gschedule_type"
    t.integer "def_group_of_gwschedule_id"
    t.string  "def_group_of_gwschedule_type"
    t.integer "def_company_of_action"
    t.integer "def_organization_of_action"
    t.string  "created_at",                   :limit => 14
    t.string  "updated_at",                   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "pj_input_option_categories", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "project_id",                                :null => false
    t.string  "category",     :limit => 30,                :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "pj_input_option_values", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "project_id"
    t.integer "input_option_category_id",                              :null => false
    t.string  "name1",                    :limit => 30
    t.string  "name2",                    :limit => 30
    t.string  "name3",                    :limit => 30
    t.string  "name4",                    :limit => 30
    t.string  "name5",                    :limit => 30
    t.string  "name6",                    :limit => 30
    t.string  "name7",                    :limit => 30
    t.string  "name8",                    :limit => 30
    t.string  "name9",                    :limit => 30
    t.string  "name10",                   :limit => 30
    t.string  "value",                    :limit => 10,                :null => false
    t.integer "position"
    t.string  "created_at",               :limit => 14
    t.string  "updated_at",               :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "pj_input_options", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "project_id",                                :null => false
    t.string  "category",                                  :null => false
    t.integer "name_po",                                   :null => false
    t.string  "value",                                     :null => false
    t.integer "position"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
    t.integer "original",     :limit => 1,  :default => 0, :null => false
  end

  create_table "po_arguments", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "po_message_id",                              :null => false
    t.string  "name",                                       :null => false
    t.string  "value",                                      :null => false
    t.string  "created_at",    :limit => 14
    t.string  "updated_at",    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "po_messages", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "type",                                      :null => false
    t.string  "msgctxt"
    t.text    "msgid",                                     :null => false
    t.text    "msgid_plural"
    t.string  "msgid_n"
    t.boolean "modified"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  add_index "po_messages", ["id", "domain_id", "type"], :name => "idx_po_messages"

  create_table "po_translations", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "type",                                       :null => false
    t.integer "po_message_id",                              :null => false
    t.text    "msgstr"
    t.text    "msgstr_0"
    t.text    "msgstr_1"
    t.text    "msgstr_2"
    t.text    "msgstr_3"
    t.text    "msgstr_4"
    t.text    "msgstr_5"
    t.string  "created_at",    :limit => 14
    t.string  "updated_at",    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  add_index "po_translations", ["po_message_id", "type"], :name => "idx_po_translations"

  create_table "portals", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "user_id",                                   :null => false
    t.string  "pattern",                                   :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "portlet_configs", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "portlet_id",                                :null => false
    t.string  "name",                                      :null => false
    t.string  "value"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "portlets", :force => true do |t|
    t.integer "domain_id",                                      :null => false
    t.integer "portal_id",                                      :null => false
    t.integer "pane_id",                                        :null => false
    t.integer "position"
    t.integer "portlettable_id",                                :null => false
    t.string  "portlettable_type",                              :null => false
    t.string  "created_at",        :limit => 14
    t.string  "updated_at",        :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                    :default => 0, :null => false
  end

  create_table "portlettable_groups", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "name_po",                                   :null => false
    t.string  "category",                                  :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "portlettable_members", :force => true do |t|
    t.integer "domain_id",                                          :null => false
    t.integer "portlettable_group_id",                              :null => false
    t.string  "category",                                           :null => false
    t.integer "portlettable_id",                                    :null => false
    t.string  "portlettable_type",                                  :null => false
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :default => 0, :null => false
  end

  create_table "posted_tos", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "person_id"
    t.integer "post_id"
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "posts", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "company_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.string  "phonetic",     :limit => 150
    t.text    "remarks"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "precede_task_records", :force => true do |t|
    t.integer "domain_id"
    t.string  "date_of_change",         :limit => 14
    t.integer "change_person_id"
    t.integer "task_id"
    t.integer "precede_task_id"
    t.boolean "confirmation_of_delete"
    t.string  "created_at",             :limit => 14
    t.string  "updated_at",             :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
    t.integer "task_record_id"
  end

  create_table "precede_tasks", :force => true do |t|
    t.integer "domain_id"
    t.integer "task_id"
    t.integer "precede_task_id"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                  :default => 0, :null => false
  end

  create_table "products", :force => true do |t|
    t.integer "domain_id",                                                 :null => false
    t.string  "code",                                                      :null => false
    t.integer "name_po",                                                   :null => false
    t.string  "motion"
    t.integer "parent_id"
    t.integer "lft"
    t.integer "rgt"
    t.string  "type",                                                      :null => false
    t.string  "model_name",              :limit => 50
    t.string  "table_name",              :limit => 50
    t.string  "detail_model_name",       :limit => 50
    t.string  "detail_table_name",       :limit => 50
    t.boolean "parent_succeeded"
    t.string  "pivot"
    t.boolean "workflow_enabled"
    t.string  "workflow"
    t.boolean "mail"
    t.boolean "mail_skip_auth"
    t.boolean "document"
    t.string  "document_name_method",    :limit => 50, :default => "name"
    t.string  "document_number_method",  :limit => 50, :default => "id"
    t.string  "document_content_method", :limit => 50, :default => "name"
    t.boolean "attachment"
    t.boolean "search"
    t.boolean "csv"
    t.string  "initial_roleable_type",   :limit => 20
    t.string  "scope_roleable_type",     :limit => 20
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0,      :null => false
    t.string  "workflow_body_method",    :limit => 50
    t.boolean "permission_enabled"
  end

  add_index "products", ["domain_id", "parent_id"], :name => "idx_products_01"

  create_table "project_design_changes", :force => true do |t|
    t.integer "domain_id",                                                  :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_design_change_number", :limit => 30
    t.string  "subject",                      :limit => 300
    t.string  "emergency_degree"
    t.string  "request_date",                 :limit => 8
    t.integer "request_person_id"
    t.string  "amount_of_estimate",           :limit => 10
    t.text    "change_content"
    t.string  "change_target",                :limit => 300
    t.string  "expected_date_of_recovery",    :limit => 8
    t.integer "person_of_recovery_id"
    t.string  "situation_of_recovery"
    t.text    "content_of_recovery"
    t.string  "date_of_recovery",             :limit => 8
    t.string  "release_date",                 :limit => 8
    t.string  "created_at",                   :limit => 14
    t.string  "updated_at",                   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                :default => 0, :null => false
  end

  create_table "project_evm_totals", :force => true do |t|
    t.integer "domain_id"
    t.integer "project_id"
    t.string  "total_date",                 :limit => 14
    t.float   "plan_progress_rate"
    t.integer "delayed_days_before_start"
    t.integer "delayed_days_until_finish"
    t.float   "budget_at_completion"
    t.float   "planed_value"
    t.float   "earned_value"
    t.float   "actual_cost"
    t.float   "schedule_variance"
    t.float   "schedule_performance_index"
    t.float   "cost_variance"
    t.float   "cost_performance_index"
    t.float   "estimate_to_comlete"
    t.float   "estimate_at_completion"
    t.float   "variance_at_completion"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                             :default => 0, :null => false
  end

  create_table "project_members", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "project_id"
    t.integer "person_id"
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
    t.integer "position"
  end

  create_table "project_problems", :force => true do |t|
    t.integer "domain_id",                                                 :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_problem_number",      :limit => 30
    t.string  "subject",                     :limit => 300
    t.integer "person_of_issued_id"
    t.integer "person_in_charge_of_work_id"
    t.string  "category"
    t.string  "priority_level"
    t.string  "process"
    t.string  "process_of_solution"
    t.text    "content_of_problem"
    t.text    "content_to_solve"
    t.string  "plan_of_start_date",          :limit => 8
    t.string  "start_date",                  :limit => 8
    t.string  "plan_of_end_date",            :limit => 8
    t.string  "end_date",                    :limit => 8
    t.string  "situation_of_work"
    t.text    "notes"
    t.string  "created_at",                  :limit => 14
    t.string  "updated_at",                  :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "project_questions", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_question_number", :limit => 30
    t.string  "subject",                 :limit => 300
    t.integer "person_of_issued_id"
    t.integer "expected_respondent_id"
    t.string  "category"
    t.string  "priority_level"
    t.string  "process"
    t.string  "process_of_solution"
    t.text    "question"
    t.text    "answer"
    t.string  "expected_answer_date",    :limit => 8
    t.string  "answer_date",             :limit => 8
    t.string  "situation_of_work"
    t.text    "notes"
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
  end

  create_table "project_report_details", :force => true do |t|
    t.integer "domain_id",                                            :null => false
    t.integer "project_report_id"
    t.text    "contents_of_work_report"
    t.string  "work_situation"
    t.integer "position"
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0, :null => false
  end

  create_table "project_reports", :force => true do |t|
    t.integer "domain_id",                                           :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_report_number", :limit => 30
    t.string  "subject",               :limit => 300
    t.string  "report_team_from_day",  :limit => 8
    t.string  "report_team_to_day",    :limit => 8
    t.text    "notes"
    t.string  "created_at",            :limit => 14
    t.string  "updated_at",            :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                         :default => 0, :null => false
  end

  create_table "project_reviews", :force => true do |t|
    t.integer "domain_id",                                            :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_review_number",  :limit => 30
    t.string  "subject",                :limit => 300
    t.string  "practice_date",          :limit => 8
    t.string  "start_time",             :limit => 5
    t.string  "end_time",               :limit => 5
    t.integer "review_person"
    t.integer "attendance_person"
    t.string  "review_process"
    t.string  "review_target",          :limit => 300
    t.string  "review_times",           :limit => 10
    t.text    "indication_item"
    t.text    "content_of_recovery"
    t.string  "date_of_recovery",       :limit => 8
    t.integer "person_of_recovery"
    t.string  "date_of_confirmation"
    t.integer "person_of_confirmation"
    t.string  "created_at",             :limit => 14
    t.string  "updated_at",             :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0, :null => false
  end

  create_table "project_segments", :force => true do |t|
    t.integer "domain_id",                                        :null => false
    t.integer "project_id"
    t.string  "code",               :limit => 30
    t.string  "name",               :limit => 150
    t.string  "segment_end_date",   :limit => 8
    t.string  "plan_of_start_date", :limit => 8
    t.string  "plan_of_end_date",   :limit => 8
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0, :null => false
  end

  create_table "project_test_reports", :force => true do |t|
    t.integer "domain_id",                                                :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_test_report_number", :limit => 30
    t.string  "subject",                    :limit => 300
    t.string  "test_division"
    t.text    "test_content"
    t.integer "designer"
    t.integer "person_in_charge_of_test"
    t.string  "end_data_of_test",           :limit => 8
    t.string  "number_of_assumed_bugs",     :limit => 20
    t.string  "number_of_found_bugs",       :limit => 20
    t.string  "number_of_standard_tests",   :limit => 20
    t.string  "number_of_actual_tests",     :limit => 20
    t.text    "notes"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                              :default => 0, :null => false
  end

  create_table "project_troubles", :force => true do |t|
    t.integer "domain_id",                                                  :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.string  "project_trouble_number",       :limit => 30
    t.text    "subject"
    t.string  "operation_division",           :limit => 10
    t.text    "trouble_content"
    t.string  "trouble_target",               :limit => 300
    t.string  "emergency_degree",             :limit => 10
    t.string  "expected_date_of_recovery",    :limit => 8
    t.integer "expected_person_of_recovery"
    t.string  "found_date",                   :limit => 8
    t.integer "found_person"
    t.string  "found_process",                :limit => 10
    t.string  "found_means",                  :limit => 10
    t.string  "process_should_be_extirpated", :limit => 10
    t.string  "cause_of_happening",           :limit => 10
    t.string  "kind_of_trouble",              :limit => 10
    t.integer "person_of_recovery"
    t.string  "situation_of_recovery",        :limit => 10
    t.text    "cause_of_trouble"
    t.text    "treatment_of_recovery"
    t.string  "end_date_of_work",             :limit => 8
    t.string  "created_at",                   :limit => 14
    t.string  "updated_at",                   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                :default => 0, :null => false
  end

  create_table "projects", :force => true do |t|
    t.integer "domain_id",                                                    :null => false
    t.string  "code",                           :limit => 30
    t.string  "name",                           :limit => 150
    t.integer "company_in_charge_id"
    t.string  "project_end_date",               :limit => 8
    t.integer "charge_of_organization"
    t.string  "matter_division"
    t.integer "client_company_id"
    t.integer "person_in_charge_of_client_id"
    t.string  "order_precision"
    t.string  "order_stage"
    t.string  "matter_start_date",              :limit => 8
    t.integer "delivery_destination_id"
    t.string  "delivery_date",                  :limit => 8
    t.integer "person_in_charge_of_sales_id"
    t.string  "order_amount",                   :limit => 12
    t.integer "person_in_charge_of_project_id"
    t.text    "remarks"
    t.integer "retrieval_division_id1"
    t.integer "retrieval_division_id2"
    t.integer "retrieval_division_id3"
    t.integer "retrieval_division_id4"
    t.integer "retrieval_division_id5"
    t.integer "retrieval_division_id6"
    t.integer "retrieval_division_id7"
    t.integer "retrieval_division_id8"
    t.integer "retrieval_division_id9"
    t.integer "retrieval_division_id10"
    t.string  "created_at",                     :limit => 14
    t.string  "updated_at",                     :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                  :default => 0, :null => false
  end

  create_table "regular_forms", :force => true do |t|
    t.integer "domain_id",                                   :null => false
    t.string  "code",          :limit => 30
    t.string  "name",          :limit => 150
    t.string  "title_of_mail", :limit => 150
    t.text    "context"
    t.string  "created_at",    :limit => 14
    t.string  "updated_at",    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                 :default => 0, :null => false
  end

  create_table "regular_tasks", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.string  "code",            :limit => 30
    t.string  "name",            :limit => 150
    t.integer "company_id"
    t.integer "organization_id"
    t.text    "context"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "retrieval_divisions", :force => true do |t|
    t.integer "domain_id",                                        :null => false
    t.string  "code",               :limit => 30
    t.string  "name",               :limit => 150
    t.string  "retrieval_division", :limit => 2
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0, :null => false
  end

  create_table "schedule_divisions", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.string  "code",            :limit => 30
    t.string  "name",            :limit => 150
    t.string  "color_rgb",       :limit => 6
    t.string  "symbol",          :limit => 6
    t.string  "use_in_schedule", :limit => 1
    t.integer "position"
    t.string  "created_at",      :limit => 14
    t.string  "updated_at",      :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "schedule_headlines", :force => true do |t|
    t.integer "domain_id",                                        :null => false
    t.integer "person_id"
    t.string  "headline_start_day", :limit => 8
    t.string  "headline_end_day",   :limit => 8
    t.string  "subject",            :limit => 400
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0, :null => false
  end

  create_table "schedule_participants", :force => true do |t|
    t.integer "domain_id",                                          :null => false
    t.integer "schedule_id"
    t.integer "person_id"
    t.string  "participation_status", :limit => 1
    t.boolean "readed_status"
    t.string  "calling_status",       :limit => 1
    t.string  "request_status",       :limit => 1
    t.string  "notes",                :limit => 400
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :default => 0, :null => false
  end

  create_table "schedules", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.string  "kind_of_schedule",        :limit => 1
    t.integer "schedule_division_id"
    t.integer "person_id"
    t.string  "schedule_start_day",      :limit => 8
    t.string  "schedule_start_time",     :limit => 4
    t.string  "schedule_end_day",        :limit => 8
    t.string  "schedule_end_time",       :limit => 4
    t.string  "subject",                 :limit => 600
    t.string  "destination"
    t.text    "content"
    t.string  "importance",              :limit => 1
    t.boolean "go_straight"
    t.boolean "go_home_directly"
    t.string  "visitor_company_name",    :limit => 400
    t.string  "visitor_name",            :limit => 400
    t.string  "conference",              :limit => 400
    t.boolean "requesting"
    t.string  "acccess_inside",          :limit => 1
    t.string  "acccess_outside",         :limit => 1
    t.string  "acccess_into_project",    :limit => 1
    t.string  "send_mail",               :limit => 1
    t.integer "regular_schedule_number"
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                           :default => 0, :null => false
    t.integer "parent_schedule_id"
    t.string  "request_send_mail",       :limit => 1
    t.string  "after_request",           :limit => 1
    t.boolean "deleted"
    t.boolean "canceled"
  end

  create_table "screens", :force => true do |t|
    t.integer "domain_id",                                     :null => false
    t.integer "displayable_id",                                :null => false
    t.string  "displayable_type",                              :null => false
    t.string  "created_at",       :limit => 14
    t.string  "updated_at",       :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                   :default => 0, :null => false
  end

  create_table "search_condition_items", :force => true do |t|
    t.integer "domain_id",                                             :null => false
    t.integer "search_condition_id",                                   :null => false
    t.integer "item_id",                                               :null => false
    t.integer "position"
    t.string  "condition_value"
    t.string  "condition_pattern"
    t.string  "order_by",                          :default => "none", :null => false
    t.string  "created_at",          :limit => 14
    t.string  "updated_at",          :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0,      :null => false
  end

  create_table "search_conditions", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.integer "person_id",                                 :null => false
    t.integer "display_id",                                :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "segment_apply_frameworks", :force => true do |t|
    t.integer "domain_id"
    t.integer "project_id"
    t.integer "segment_id"
    t.integer "apply_framework_id"
    t.integer "apply_person_id"
    t.string  "apply_date",         :limit => 14
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                     :default => 0, :null => false
  end

  create_table "segment_checklist_judgments", :force => true do |t|
    t.integer "domain_id",                                   :null => false
    t.integer "segment_checklist_task_id"
    t.string  "segment_checklist_task_number", :limit => 30
    t.string  "judgment_result",               :limit => 1
    t.integer "judgment_person_id"
    t.string  "judgment_date",                 :limit => 8
    t.text    "judgment_comment"
    t.string  "confirm_date",                  :limit => 8
    t.integer "confirm_person_id"
    t.text    "confirm_comment"
    t.integer "judgment_of"
    t.string  "created_at",                    :limit => 14
    t.string  "updated_at",                    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                                :null => false
  end

  create_table "segment_checklist_tasks", :force => true do |t|
    t.integer "domain_id",                           :null => false
    t.integer "segment_checklist_id",                :null => false
    t.integer "parent_id"
    t.string  "code",                 :limit => 30,  :null => false
    t.string  "name",                 :limit => 150, :null => false
    t.text    "explanation"
    t.boolean "judgment"
    t.integer "position",                            :null => false
    t.integer "task_level",                          :null => false
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :null => false
  end

  create_table "segment_checklists", :force => true do |t|
    t.integer "domain_id",                   :null => false
    t.integer "project_id"
    t.integer "segment_id"
    t.integer "checklist_id"
    t.string  "code",         :limit => 30
    t.string  "name",         :limit => 150
    t.text    "explanation"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :null => false
  end

  create_table "segment_evm_totals", :force => true do |t|
    t.integer "domain_id"
    t.integer "segment_id"
    t.string  "total_date",                 :limit => 14
    t.float   "plan_progress_rate"
    t.integer "delayed_days_before_start"
    t.integer "delayed_days_until_finish"
    t.float   "budget_at_completion"
    t.float   "planed_value"
    t.float   "earned_value"
    t.float   "actual_cost"
    t.float   "schedule_variance"
    t.float   "schedule_performance_index"
    t.float   "cost_variance"
    t.float   "cost_performance_index"
    t.float   "estimate_to_comlete"
    t.float   "estimate_at_completion"
    t.float   "variance_at_completion"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                             :default => 0, :null => false
  end

  create_table "segment_folders", :force => true do |t|
    t.integer "domain_id",                  :null => false
    t.integer "project_id",                 :null => false
    t.integer "segment_id",                 :null => false
    t.string  "name",                       :null => false
    t.text    "explanation"
    t.integer "parent_id"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :null => false
  end

  create_table "shared_lists", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.integer "display_id",                                 :null => false
    t.integer "roleable_id",                                :null => false
    t.string  "roleable_type",                              :null => false
    t.string  "created_at",    :limit => 14
    t.string  "updated_at",    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

  create_table "sharing_folders", :force => true do |t|
    t.integer "domain_id",                  :null => false
    t.string  "name",                       :null => false
    t.text    "explanation"
    t.integer "parent_id"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :null => false
  end

  create_table "storage_objects", :force => true do |t|
    t.integer "domain_id",                                                          :null => false
    t.string  "name"
    t.string  "mime_type",                  :default => "application/octet-stream", :null => false
    t.string  "uri"
    t.integer "length"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0,                          :null => false
  end

  create_table "storages", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "root",                                      :null => false
    t.string  "separator",                                 :null => false
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "table_columns", :force => true do |t|
    t.integer "domain_id",                                        :null => false
    t.string  "table_type",                                       :null => false
    t.integer "table_id",                                         :null => false
    t.string  "name",                                             :null => false
    t.string  "type",                                             :null => false
    t.integer "length"
    t.string  "relation_table_name"
    t.string  "relation_item_name"
    t.boolean "polymorphic"
    t.string  "dependent"
    t.string  "created_at",          :limit => 14
    t.string  "updated_at",          :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                      :default => 0, :null => false
    t.boolean "application_key"
  end

  create_table "task_conditions", :force => true do |t|
    t.integer "domain_id"
    t.integer "task_id"
    t.integer "display_id"
    t.integer "person_id"
    t.string  "task_open_and_shut", :limit => 1
    t.string  "created_at",         :limit => 14
    t.string  "updated_at",         :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                     :default => 0, :null => false
  end

  create_table "task_evm_totals", :force => true do |t|
    t.integer "domain_id"
    t.integer "task_id"
    t.string  "total_date",                 :limit => 11
    t.float   "plan_progress_rate"
    t.integer "delayed_days_before_start"
    t.integer "delayed_days_until_finish"
    t.float   "planed_value"
    t.float   "earned_value"
    t.float   "actual_cost"
    t.float   "schedule_variance"
    t.float   "schedule_performance_index"
    t.float   "cost_variance"
    t.float   "cost_performance_index"
    t.float   "estimate_to_comlete"
    t.float   "estimate_at_completion"
    t.float   "variance_at_completion"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                             :default => 0, :null => false
  end

  create_table "task_memories", :force => true do |t|
    t.integer "domain_id"
    t.integer "display_id"
    t.integer "person_id"
    t.boolean "do_not_show_finished_task"
    t.boolean "show_task_of_delayed_start"
    t.boolean "show_task_of_delayed_finish"
    t.boolean "show_task_in_progress"
    t.string  "record_of_certain_term",       :limit => 5
    t.boolean "basic_point_of_appointed_day"
    t.boolean "graph_type"
    t.boolean "display_type"
    t.string  "created_at",                   :limit => 14
    t.string  "updated_at",                   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "task_milestone_records", :force => true do |t|
    t.integer "domain_id"
    t.string  "date_of_change",             :limit => 14
    t.integer "change_person_id"
    t.integer "task_milestone_id"
    t.integer "task_id"
    t.string  "code",                       :limit => 30
    t.string  "name",                       :limit => 150
    t.float   "milestone_progress_rate"
    t.boolean "confirmation_of_completion"
    t.string  "operation_finish_date",      :limit => 14
    t.integer "milestone_id"
    t.integer "milestone_display_order"
    t.boolean "confirmation_of_delete"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                              :default => 0, :null => false
    t.integer "task_record_id"
  end

  create_table "task_milestones", :force => true do |t|
    t.integer "domain_id"
    t.integer "task_id"
    t.string  "code",                       :limit => 30
    t.string  "name",                       :limit => 150
    t.float   "milestone_progress_rate"
    t.boolean "confirmation_of_completion"
    t.string  "finish_date",                :limit => 14
    t.integer "milestone_id"
    t.integer "milestone_display_order"
    t.string  "created_at",                 :limit => 14
    t.string  "updated_at",                 :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                              :default => 0, :null => false
  end

  create_table "task_records", :force => true do |t|
    t.integer "domain_id"
    t.string  "date_of_change",              :limit => 14
    t.integer "change_person_id"
    t.integer "project_id"
    t.integer "segment_id"
    t.integer "task_id"
    t.integer "parent_id"
    t.integer "lft"
    t.integer "rgt"
    t.string  "code",                        :limit => 30
    t.string  "name",                        :limit => 150
    t.string  "planned_start_date",          :limit => 14
    t.string  "planned_finish_date",         :limit => 14
    t.string  "operation_start_date",        :limit => 14
    t.string  "operation_finish_date",       :limit => 14
    t.string  "planned_scale",               :limit => 20
    t.string  "actual_result_scale",         :limit => 20
    t.float   "planned_man_hour"
    t.float   "actual_result_man_hour"
    t.string  "results_object",              :limit => 300
    t.integer "task_weight"
    t.integer "person_in_charge_of_work_id"
    t.float   "progress_rate"
    t.float   "task_weight_progress_rate"
    t.integer "number_of_operating_days"
    t.float   "budget_at_completion"
    t.float   "actual_cost"
    t.integer "fromwork_task_id"
    t.text    "note"
    t.string  "created_at",                  :limit => 14
    t.string  "updated_at",                  :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
    t.integer "task_record_id"
    t.string  "content_of_changed",          :limit => 45
    t.string  "high_rank_changed",           :limit => 45
  end

  create_table "tasks", :force => true do |t|
    t.integer "domain_id"
    t.integer "project_id"
    t.integer "segment_id"
    t.integer "parent_id"
    t.integer "lft"
    t.integer "rgt"
    t.integer "task_level"
    t.string  "data_type",                   :limit => 10
    t.string  "code",                        :limit => 30
    t.string  "name",                        :limit => 150
    t.string  "planned_start_date",          :limit => 14
    t.string  "planned_finish_date",         :limit => 14
    t.string  "operation_start_date",        :limit => 14
    t.string  "operation_finish_date",       :limit => 14
    t.string  "planned_scale",               :limit => 20
    t.string  "actual_result_scale",         :limit => 20
    t.float   "planned_man_hour"
    t.float   "actual_result_man_hour"
    t.string  "results_object",              :limit => 300
    t.integer "task_weight"
    t.integer "person_in_charge_of_work_id"
    t.float   "progress_rate"
    t.float   "task_weight_progress_rate"
    t.integer "number_of_operating_days"
    t.float   "budget_at_completion"
    t.float   "actual_cost"
    t.integer "framework_task_id"
    t.text    "notes"
    t.string  "created_at",                  :limit => 14
    t.string  "updated_at",                  :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                               :default => 0, :null => false
  end

  create_table "tax_rates", :force => true do |t|
    t.integer "domain_id",                                 :null => false
    t.string  "inception",    :limit => 8
    t.string  "expiry",       :limit => 8
    t.float   "tax_rate"
    t.string  "created_at",   :limit => 14
    t.string  "updated_at",   :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",               :default => 0, :null => false
  end

  create_table "users", :force => true do |t|
    t.integer  "domain_id",                                               :null => false
    t.integer  "person_id",                                               :null => false
    t.string   "login",                 :limit => 80,                     :null => false
    t.string   "salted_password",       :limit => 128,                    :null => false
    t.boolean  "admin",                                :default => false, :null => false
    t.integer  "list_default_per_page",                :default => 10,    :null => false
    t.integer  "list_header_per_line",                 :default => 10,    :null => false
    t.integer  "menu_history_max",                     :default => 10,    :null => false
    t.string   "salt",                  :limit => 128,                    :null => false
    t.boolean  "verified",                             :default => false, :null => false
    t.string   "security_token",        :limit => 128
    t.datetime "token_expiry"
    t.boolean  "deleted",                              :default => false, :null => false
    t.integer  "failed_login_count",                   :default => 0,     :null => false
    t.string   "password_updated_on",   :limit => 8
    t.string   "created_at",            :limit => 14
    t.string   "updated_at",            :limit => 14
    t.integer  "created_by"
    t.integer  "updated_by"
    t.integer  "created_in"
    t.integer  "updated_in"
    t.integer  "lock_version",                         :default => 0,     :null => false
  end

  add_index "users", ["login"], :name => "index_users_on_login"

  create_table "work_report_details", :force => true do |t|
    t.integer "domain_id",                                            :null => false
    t.integer "work_report_id"
    t.text    "contents_of_work_report"
    t.string  "work_situation"
    t.string  "start_date",              :limit => 8
    t.string  "plan_of_end_date",        :limit => 8
    t.string  "end_date",                :limit => 8
    t.float   "progress_rate"
    t.string  "delay_days",              :limit => 10
    t.integer "position"
    t.string  "created_at",              :limit => 14
    t.string  "updated_at",              :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                          :default => 0, :null => false
  end

  create_table "work_reports", :force => true do |t|
    t.integer "domain_id",                                          :null => false
    t.string  "work_report_number",   :limit => 30
    t.string  "subject",              :limit => 300
    t.string  "report_team_from_day", :limit => 8
    t.string  "report_team_to_day",   :limit => 8
    t.text    "notes"
    t.string  "created_at",           :limit => 14
    t.string  "updated_at",           :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                        :default => 0, :null => false
  end

  create_table "workshops", :force => true do |t|
    t.integer "domain_id",                                  :null => false
    t.string  "name"
    t.string  "ymd"
    t.integer "promoter_id"
    t.string  "promoter_type"
    t.string  "members"
    t.string  "created_at",    :limit => 14
    t.string  "updated_at",    :limit => 14
    t.integer "created_by"
    t.integer "updated_by"
    t.integer "created_in"
    t.integer "updated_in"
    t.integer "lock_version",                :default => 0, :null => false
  end

end
