class ChangeSomeColumnForAccessLog < ActiveRecord::Migration
  def self.up
    remove_index :access_logs, :uuid
    drop_table :access_logs

    invalidity_columns = {
      :domain_id => false,
      :created_by => false,
      :updated_by => false,
      :created_in => false,
      :updated_in => false,
      :lock_version => false,
    }
    create_table :access_logs, invalidity_columns do |t|
      t.string :uuid, :limit => 36
      t.float :response_time, :null => false
      t.integer :login_id
      t.datetime :accessed_at, :null => false
      t.string :ip_address, :limit => 15, :null => false
      t.text :parameters, :null => false
    end
    add_index :access_logs, :uuid
  end

  def self.down
    remove_index :access_logs, :uuid
    drop_table :access_logs
    create_table :access_logs, :domain_id => false do |t|
      t.string :uuid, :limit => 36, :primary => true
      t.float :response_time, :null => false
    end
    add_index :access_logs, :uuid
  end
end
